/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.transport.mailets.remote.delivery.Bouncer;
import org.apache.james.transport.mailets.remote.delivery.Delay;
import org.apache.james.transport.mailets.remote.delivery.DeliveryRetriesHelper;
import org.apache.james.transport.mailets.remote.delivery.ExecutionResult;
import org.apache.james.transport.mailets.remote.delivery.MailDelivrer;
import org.apache.james.transport.mailets.remote.delivery.MailDelivrerToHost;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class DeliveryRunnable
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeliveryRunnable.class);
    public static final Supplier<Date> CURRENT_DATE_SUPPLIER = Date::new;
    public static final AtomicBoolean DEFAULT_NOT_STARTED = new AtomicBoolean(false);
    public static final String OUTGOING_MAILS = "outgoingMails";
    public static final String REMOTE_DELIVERY_TRIAL = "RemoteDeliveryTrial";
    private final MailQueue queue;
    private final RemoteDeliveryConfiguration configuration;
    private final Metric outgoingMailsMetric;
    private final MetricFactory metricFactory;
    private final Bouncer bouncer;
    private final MailDelivrer mailDelivrer;
    private final Supplier<Date> dateSupplier;
    private Disposable disposable;

    public DeliveryRunnable(MailQueue queue, RemoteDeliveryConfiguration configuration, DNSService dnsServer, MetricFactory metricFactory, MailetContext mailetContext, Bouncer bouncer) {
        this(queue, configuration, metricFactory, bouncer, new MailDelivrer(configuration, new MailDelivrerToHost(configuration, mailetContext), dnsServer, bouncer), CURRENT_DATE_SUPPLIER);
    }

    @VisibleForTesting
    DeliveryRunnable(MailQueue queue, RemoteDeliveryConfiguration configuration, MetricFactory metricFactory, Bouncer bouncer, MailDelivrer mailDelivrer, Supplier<Date> dateSupplier) {
        this.queue = queue;
        this.configuration = configuration;
        this.outgoingMailsMetric = metricFactory.generate(OUTGOING_MAILS);
        this.bouncer = bouncer;
        this.mailDelivrer = mailDelivrer;
        this.dateSupplier = dateSupplier;
        this.metricFactory = metricFactory;
    }

    public void start() {
        Scheduler remoteDeliveryScheduler = Schedulers.newElastic((String)"RemoteDelivery");
        this.disposable = Flux.from((Publisher)this.queue.deQueue()).publishOn(remoteDeliveryScheduler).flatMap(this::runStep).onErrorContinue((throwable, nothing) -> LOGGER.error("Exception caught in RemoteDelivery", throwable)).subscribeOn(remoteDeliveryScheduler).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mono<Void> runStep(MailQueue.MailQueueItem queueItem) {
        TimeMetric timeMetric = this.metricFactory.timer(REMOTE_DELIVERY_TRIAL);
        try {
            Mono<Void> mono = this.processMail(queueItem);
            return mono;
        }
        catch (Throwable e) {
            Mono mono = Mono.error((Throwable)e);
            return mono;
        }
        finally {
            timeMetric.stopAndPublish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mono<Void> processMail(MailQueue.MailQueueItem queueItem) throws MailQueue.MailQueueException {
        Mail mail = queueItem.getMail();
        try {
            LOGGER.debug("will process mail {}", (Object)mail.getName());
            this.attemptDelivery(mail);
            queueItem.done(true);
            Mono mono = Mono.empty();
            return mono;
        }
        catch (Exception e) {
            queueItem.done(false);
            Mono mono = Mono.error((Throwable)e);
            return mono;
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    @VisibleForTesting
    void attemptDelivery(Mail mail) throws MailQueue.MailQueueException {
        ExecutionResult executionResult = this.mailDelivrer.deliver(mail);
        switch (executionResult.getExecutionState()) {
            case SUCCESS: {
                this.outgoingMailsMetric.increment();
                break;
            }
            case TEMPORARY_FAILURE: {
                this.handleTemporaryFailure(mail, executionResult);
                break;
            }
            case PERMANENT_FAILURE: {
                this.bouncer.bounce(mail, executionResult.getException().orElse(null));
            }
        }
    }

    private void handleTemporaryFailure(Mail mail, ExecutionResult executionResult) throws MailQueue.MailQueueException {
        int retries;
        if (!mail.getState().equals("error")) {
            mail.setState("error");
            DeliveryRetriesHelper.initRetries(mail);
            mail.setLastUpdated(this.dateSupplier.get());
        }
        if ((retries = DeliveryRetriesHelper.retrieveRetries(mail)) < this.configuration.getMaxRetries()) {
            this.reAttemptDelivery(mail, retries);
        } else {
            LOGGER.debug("Bouncing message {} after {} retries", (Object)mail.getName(), (Object)retries);
            this.bouncer.bounce(mail, new Exception("Too many retries failure. Bouncing after " + retries + " retries.", executionResult.getException().orElse(null)));
        }
    }

    private void reAttemptDelivery(Mail mail, int retries) throws MailQueue.MailQueueException {
        LOGGER.debug("Storing message {} into outgoing after {} retries", (Object)mail.getName(), (Object)retries);
        DeliveryRetriesHelper.incrementRetries(mail);
        mail.setLastUpdated(this.dateSupplier.get());
        Duration delay = this.getNextDelay(DeliveryRetriesHelper.retrieveRetries(mail));
        if (this.configuration.isUsePriority()) {
            mail.setAttribute(MailPrioritySupport.LOW_PRIORITY_ATTRIBUTE);
        }
        this.queue.enQueue(mail, delay);
    }

    private Duration getNextDelay(int retry_count) {
        if (retry_count > this.configuration.getDelayTimes().size()) {
            return Delay.DEFAULT_DELAY_TIME;
        }
        return this.configuration.getDelayTimes().get(retry_count - 1);
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

