/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.managesieve.transcode;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.managesieve.api.ManageSieveException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.sieverepository.api.exception.SieveRepositoryException;

public class MessageToCoreToMessage {
    private final ManageSieveProcessor manageSieveProcessor;
    private final HelpProvider helpProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getScript(MimeMessage message) throws IOException, MessagingException {
        String result = null;
        if (message.getContentType().startsWith("multipart/")) {
            MimeMultipart parts = (MimeMultipart)message.getContent();
            boolean found = false;
            for (int i = 0; !found && i < parts.getCount(); ++i) {
                MimeBodyPart part = (MimeBodyPart)parts.getBodyPart(i);
                found = part.isMimeType("application/sieve");
                if (!found) {
                    String fileName = null == part.getFileName() ? null : part.getFileName().toLowerCase(Locale.US);
                    boolean bl = found = fileName != null && (fileName.endsWith(".siv") || fileName.endsWith(".sieve"));
                }
                if (!found) continue;
                Object content = part.getContent();
                if (content instanceof String) {
                    return (String)part.getContent();
                }
                InputStream is = (InputStream)part.getContent();
                try (Scanner scanner = null;){
                    scanner = new Scanner(is, "UTF-8");
                    scanner.useDelimiter("\\A");
                    if (!scanner.hasNext()) continue;
                    result = scanner.next();
                    continue;
                }
            }
        }
        if (null == result) {
            throw new MessagingException("Script part not found in this message");
        }
        return result;
    }

    protected static MimeBodyPart toPart(String message) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(message);
        part.setDisposition("inline");
        return part;
    }

    public MessageToCoreToMessage(ManageSieveProcessor manageSieveProcessor, HelpProvider helpProvider) {
        this.manageSieveProcessor = manageSieveProcessor;
        this.helpProvider = helpProvider;
    }

    public MimeMessage execute(Session session, MimeMessage message) throws MessagingException {
        MimeMessage reply = (MimeMessage)message.reply(false);
        reply.setContent((Multipart)this.computeMultiPartResponse(session, message));
        if (null == message.getAllRecipients() || 0 >= message.getAllRecipients().length) {
            throw new MessagingException("Message has no recipients");
        }
        Address from = message.getAllRecipients()[0];
        reply.setFrom(from);
        reply.saveChanges();
        return reply;
    }

    private MimeMultipart computeMultiPartResponse(Session session, MimeMessage message) throws MessagingException {
        String subject;
        String string = subject = null == message.getSubject() ? "" : message.getSubject();
        if (subject.startsWith("HELP")) {
            return this.help();
        }
        String result = this.computeStringResult(session, message, subject);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(result));
        return multipart;
    }

    protected MimeMultipart help() throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this.helpProvider.getHelp()));
        return multipart;
    }

    private String computeStringResult(Session session, MimeMessage message, String subject) {
        try {
            return this.manageSieveProcessor.handleRequest(session, subject + "\r\n" + this.retrieveAttachedScript(message));
        }
        catch (ManageSieveException e) {
            return "NO Manage sieve exception : " + e.getMessage();
        }
        catch (SieveRepositoryException e) {
            return "NO SieveRepository exception : " + e.getMessage();
        }
    }

    private String retrieveAttachedScript(MimeMessage message) {
        try {
            return MessageToCoreToMessage.getScript(message);
        }
        catch (IOException | MessagingException e) {
            return "";
        }
    }

    public static interface HelpProvider {
        public String getHelp() throws MessagingException;
    }
}

