/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Streams;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import reactor.core.publisher.Mono;

public class RandomStoring
extends GenericMailet {
    private static final int MIN_NUMBER_OF_RECIPIENTS = 4;
    private static final int MAX_NUMBER_OF_RECIPIENTS = 8;
    private static final Duration CACHE_DURATION = Duration.ofMinutes(15L);
    private final Mono<List<ReroutingInfos>> reroutingInfos;
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final Supplier<Integer> randomRecipientsNumbers;

    @Inject
    public RandomStoring(UsersRepository usersRepository, MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
        this.randomRecipientsNumbers = () -> ThreadLocalRandom.current().nextInt(4, 9);
        this.reroutingInfos = Mono.fromCallable(this::retrieveReroutingInfos).cache(CACHE_DURATION);
    }

    public void service(Mail mail) throws MessagingException {
        Collection<ReroutingInfos> reroutingInfos = this.generateRandomMailboxes();
        Collection mailAddresses = (Collection)reroutingInfos.stream().map(ReroutingInfos::getMailAddress).collect(Guavate.toImmutableList());
        mail.setRecipients(mailAddresses);
        reroutingInfos.forEach(reroutingInfo -> mail.setAttribute(Attribute.convertToAttribute((String)("DeliveryPath_" + reroutingInfo.getUser()), (Object)reroutingInfo.getMailbox())));
    }

    public String getMailetInfo() {
        return "Random Storing Mailet";
    }

    public void init() throws MessagingException {
    }

    private Collection<ReroutingInfos> generateRandomMailboxes() {
        List reroutingInfos = (List)this.reroutingInfos.block();
        return (Collection)ThreadLocalRandom.current().ints(0, reroutingInfos.size()).mapToObj(reroutingInfos::get).distinct().limit(this.randomRecipientsNumbers.get().intValue()).collect(Guavate.toImmutableSet());
    }

    private List<ReroutingInfos> retrieveReroutingInfos() throws UsersRepositoryException {
        return (List)Streams.stream((Iterator)this.usersRepository.list()).map(User::fromUsername).flatMap(this::buildReRoutingInfos).collect(Guavate.toImmutableList());
    }

    private Stream<ReroutingInfos> buildReRoutingInfos(User user) {
        try {
            MailAddress mailAddress = this.usersRepository.getMailAddressFor(user);
            MailboxSession session = this.mailboxManager.createSystemSession(user.asString());
            return this.mailboxManager.list(session).stream().map(mailboxPath -> new ReroutingInfos(mailAddress, mailboxPath.getName(), user.asString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class ReroutingInfos {
        private final MailAddress mailAddress;
        private final String mailbox;
        private final String user;

        ReroutingInfos(MailAddress mailAddress, String mailbox, String user) {
            this.mailAddress = mailAddress;
            this.mailbox = mailbox;
            this.user = user;
        }

        public MailAddress getMailAddress() {
            return this.mailAddress;
        }

        public String getMailbox() {
            return this.mailbox;
        }

        public String getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o instanceof ReroutingInfos) {
                ReroutingInfos that = (ReroutingInfos)o;
                return Objects.equals(this.mailAddress, that.mailAddress) && Objects.equals(this.mailbox, that.mailbox) && Objects.equals(this.user, that.user);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mailAddress, this.mailbox, this.user);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.mailAddress.asString()).add("mailbox", (Object)this.mailbox).add("user", (Object)this.user).toString();
        }
    }
}

