/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.sql.DataSource;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.AbstractRecipientRewriteTable;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.MailetException;

@Deprecated
@Experimental
public class JDBCRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final String QUERY = "select RecipientRewriteTable.target_address from RecipientRewriteTable, RecipientRewriteTable as VUTDomains where (RecipientRewriteTable.user like ? or RecipientRewriteTable.user like '\\%') and (RecipientRewriteTable.domain like ? or (RecipientRewriteTable.domain like '%*%' and VUTDomains.domain like ?)) order by concat(RecipientRewriteTable.user,'@',RecipientRewriteTable.domain) desc limit 1";
    protected DataSource datasource;
    protected String query = null;
    private final JDBCUtil theJDBCUtil = new JDBCUtil();

    @Inject
    public void setDataSourceSelector(DataSource datasource) {
        this.datasource = datasource;
    }

    public void init() throws MessagingException {
        if (this.getInitParameter("table") == null) {
            throw new MailetException("Table location not specified for JDBCRecipientRewriteTable");
        }
        String tableURL = this.getInitParameter("table");
        String datasourceName = tableURL.substring(5);
        int pos = datasourceName.indexOf("/");
        String tableName = datasourceName.substring(pos + 1);
        datasourceName = datasourceName.substring(0, pos);
        try (Connection conn = this.datasource.getConnection();){
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                String exceptionBuffer = "Could not find table '" + tableName + "' in datasource '" + datasourceName + "'";
                throw new MailetException(exceptionBuffer);
            }
            this.query = this.getInitParameter("sqlquery", QUERY);
        }
        catch (MailetException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException("Error initializing JDBCRecipientRewriteTable", e);
        }
    }

    @Override
    protected void mapRecipients(Map<MailAddress, String> recipientsMap) throws MessagingException {
        Set<MailAddress> recipients = recipientsMap.keySet();
        try (Connection conn = this.datasource.getConnection();
             PreparedStatement mappingStmt = conn.prepareStatement(this.query);){
            for (MailAddress recipient : recipients) {
                mappingStmt.setString(1, recipient.getLocalPart());
                mappingStmt.setString(2, recipient.getDomain().asString());
                mappingStmt.setString(3, recipient.getDomain().asString());
                ResultSet mappingRS = mappingStmt.executeQuery();
                try {
                    if (!mappingRS.next()) continue;
                    String targetString = mappingRS.getString(1);
                    recipientsMap.put(recipient, targetString);
                }
                finally {
                    if (mappingRS == null) continue;
                    mappingRS.close();
                }
            }
        }
        catch (SQLException sqle) {
            throw new MessagingException("Error accessing database", (Exception)sqle);
        }
    }

    public String getMailetInfo() {
        return "JDBC Virtual User Table mailet";
    }
}

