/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.transport.mailets.managesieve.ManageSieveMailet;
import org.apache.mailet.Attribute;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class FromRepository
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveMailet.class);
    private MailRepository repository;
    private boolean delete = false;
    private MailRepositoryUrl repositoryPath;
    private String processor;
    private MailRepositoryStore mailStore;

    @Inject
    public void setStore(MailRepositoryStore mailStore) {
        this.mailStore = mailStore;
    }

    public void init() throws MessagingException {
        this.repositoryPath = MailRepositoryUrl.from((String)this.getInitParameter("repositoryPath"));
        this.processor = this.getInitParameter("processor") == null ? "root" : this.getInitParameter("processor");
        try {
            this.delete = this.getInitParameter("delete") == null ? false : Boolean.valueOf(this.getInitParameter("delete"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.repository = this.mailStore.select(this.repositoryPath);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve MailRepository for url " + this.repositoryPath, e);
        }
    }

    public void service(Mail trigger) throws MessagingException {
        trigger.setState("ghost");
        ArrayList<MailKey> processed = new ArrayList<MailKey>();
        Iterator list = this.repository.list();
        while (list.hasNext()) {
            MailKey key = (MailKey)list.next();
            try {
                Mail mail = this.repository.retrieve(key);
                if (mail == null || mail.getRecipients() == null) continue;
                LOGGER.debug("Spooling mail {} from {}", (Object)mail.getName(), (Object)this.repositoryPath);
                mail.setAttribute(Attribute.convertToAttribute((String)"FromRepository", (Object)Boolean.TRUE));
                mail.setState(this.processor);
                this.getMailetContext().sendMail(mail);
                if (this.delete) {
                    processed.add(key);
                }
                LifecycleUtil.dispose((Object)mail);
            }
            catch (MessagingException messagingException) {
                LOGGER.error("Unable to re-spool mail {} from {}", new Object[]{key, this.repositoryPath, messagingException});
            }
        }
        if (this.delete) {
            for (Object e : processed) {
                this.repository.remove((MailKey)e);
            }
        }
    }

    public String getMailetInfo() {
        return "FromRepository Mailet";
    }
}

