/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import com.google.common.annotations.VisibleForTesting;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.CRLFOutputStream;
import org.apache.james.jdkim.mailets.HeaderSkippingOutputStream;
import org.apache.james.jdkim.mailets.MimeMessageHeaders;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class DKIMVerify
extends GenericMailet {
    public static final AttributeName DKIM_AUTH_RESULT = AttributeName.of((String)"jDKIM.AUTHRESULT");
    @VisibleForTesting
    DKIMVerifier verifier;
    private boolean forceCRLF;

    @Inject
    public DKIMVerify(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.verifier = new DKIMVerifier(publicKeyRecordRetriever);
    }

    public void init() {
        this.forceCRLF = this.getInitParameter("forceCRLF", true);
    }

    public void service(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            List<SignatureRecord> res = DKIMVerify.verify(this.verifier, message, this.forceCRLF);
            if (res == null || res.isEmpty()) {
                mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)"neutral (no signatures)")));
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("pass");
                for (SignatureRecord rec : res) {
                    msg.append(" (");
                    msg.append("identity ");
                    msg.append(rec.getIdentity().toString());
                    msg.append(")");
                }
                mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)msg.toString())));
            }
        }
        catch (FailException e) {
            String relatedRecordIdentity = Optional.ofNullable(e.getRelatedRecordIdentity()).map(value -> "identity" + value + ":").orElse("");
            mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)("fail (" + relatedRecordIdentity + e.getMessage() + ")"))));
        }
    }

    @VisibleForTesting
    static List<SignatureRecord> verify(DKIMVerifier verifier, MimeMessage message, boolean forceCRLF) throws MessagingException, FailException {
        MimeMessageHeaders headers = new MimeMessageHeaders(message);
        BodyHasher bh = verifier.newBodyHasher((Headers)headers);
        try {
            if (bh != null) {
                FilterOutputStream os = new HeaderSkippingOutputStream(bh.getOutputStream());
                if (forceCRLF) {
                    os = new CRLFOutputStream(os);
                }
                message.writeTo((OutputStream)os);
            }
        }
        catch (IOException e) {
            throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (bh != null) {
                    bh.getOutputStream().close();
                }
            }
            catch (IOException e) {
                throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
            }
        }
        return verifier.verify(bh);
    }
}

