/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CRLFOutputStream
extends FilterOutputStream {
    private static final int LAST_WAS_OTHER = 0;
    private static final int LAST_WAS_CR = 1;
    private static final int LAST_WAS_LF = 2;
    protected int statusLast = 2;
    protected boolean startOfLine = true;

    public CRLFOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        switch (b) {
            case 13: {
                this.out.write(13);
                this.out.write(10);
                this.startOfLine = true;
                this.statusLast = 1;
                break;
            }
            case 10: {
                if (this.statusLast != 1) {
                    this.out.write(13);
                    this.out.write(10);
                    this.startOfLine = true;
                }
                this.statusLast = 2;
                break;
            }
            default: {
                this.out.write(b);
                this.startOfLine = false;
                this.statusLast = 0;
            }
        }
    }

    protected void writeChunk(byte[] buffer, int offset, int length) throws IOException {
        this.out.write(buffer, offset, length);
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        int lineStart = offset;
        block4: for (int i = offset; i < length + offset; ++i) {
            switch (buffer[i]) {
                case 13: {
                    this.writeChunk(buffer, lineStart, i - lineStart);
                    this.out.write(13);
                    this.out.write(10);
                    this.startOfLine = true;
                    lineStart = i + 1;
                    this.statusLast = 1;
                    continue block4;
                }
                case 10: {
                    if (this.statusLast != 1) {
                        this.writeChunk(buffer, lineStart, i - lineStart);
                        this.out.write(13);
                        this.out.write(10);
                        this.startOfLine = true;
                    }
                    lineStart = i + 1;
                    this.statusLast = 2;
                    continue block4;
                }
                default: {
                    this.statusLast = 0;
                }
            }
        }
        if (length + offset > lineStart) {
            this.writeChunk(buffer, lineStart, length + offset - lineStart);
            this.startOfLine = false;
        }
    }

    public void checkCRLFTerminator() throws IOException {
        if (this.statusLast == 0) {
            this.out.write(13);
            this.out.write(10);
            this.statusLast = 1;
        }
    }
}

