/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.task.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.json.JsonGenericSerializer;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;

public class JsonTaskSerializer {
    private JsonGenericSerializer<Task, TaskDTO> jsonGenericSerializer;

    @Inject
    public JsonTaskSerializer(Set<TaskDTOModule> modules) {
        this.jsonGenericSerializer = new JsonGenericSerializer(modules);
    }

    public JsonTaskSerializer(TaskDTOModule ... modules) {
        this((Set<TaskDTOModule>)ImmutableSet.copyOf((Object[])modules));
    }

    public String serialize(Task task) throws JsonProcessingException {
        try {
            return this.jsonGenericSerializer.serialize((Object)task);
        }
        catch (JsonGenericSerializer.UnknownTypeException e) {
            throw new UnknownTaskException(e);
        }
    }

    public Task deserialize(String value) throws IOException {
        try {
            return (Task)this.jsonGenericSerializer.deserialize(value);
        }
        catch (JsonGenericSerializer.UnknownTypeException e) {
            throw new UnknownTaskException(e);
        }
        catch (JsonGenericSerializer.InvalidTypeException e) {
            throw new InvalidTaskException(e);
        }
    }

    public static class UnknownTaskException
    extends RuntimeException {
        public UnknownTaskException(JsonGenericSerializer.UnknownTypeException original) {
            super((Throwable)original);
        }
    }

    public static class InvalidTaskException
    extends RuntimeException {
        public InvalidTaskException(JsonGenericSerializer.InvalidTypeException original) {
            super((Throwable)original);
        }
    }
}

