/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.imap.core;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandDispatcher;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.MultiLineHandler;
import org.apache.james.protocols.imap.IMAPRequest;
import org.apache.james.protocols.imap.IMAPSession;

public class IMAPCommandDispatcher
extends CommandDispatcher<IMAPSession> {
    private static final Pattern LITERAL_PATTERN = Pattern.compile(".*\\{(\\d+)\\}.*");

    protected Request parseRequest(IMAPSession session, ByteBuffer buffer) throws Exception {
        IMAPRequest request = new IMAPRequest(buffer);
        Matcher matcher = LITERAL_PATTERN.matcher(request.getArgument());
        if (matcher.matches()) {
            final long bytesToRead = Long.parseLong(matcher.group(1));
            MultiLineHandler<IMAPSession> handler = new MultiLineHandler<IMAPSession>(){
                private static final String BYTES_READ = "BYTES_READ";

                public void init(Configuration config) throws ConfigurationException {
                }

                public void destroy() {
                }

                protected boolean isReady(IMAPSession session, ByteBuffer line) {
                    long bytesRead = (Long)session.setAttachment(BYTES_READ, null, ProtocolSession.State.Transaction);
                    if ((bytesRead += (long)line.remaining()) >= bytesToRead) {
                        return true;
                    }
                    session.setAttachment(BYTES_READ, bytesRead, ProtocolSession.State.Transaction);
                    return false;
                }

                protected Response onLines(IMAPSession session, Collection<ByteBuffer> lines) {
                    session.popLineHandler();
                    return IMAPCommandDispatcher.this.dispatchCommandHandlers(session, new IMAPRequest(lines));
                }
            };
            buffer.rewind();
            handler.onLine((ProtocolSession)session, buffer);
            session.pushLineHandler((LineHandler)handler);
            return null;
        }
        return request;
    }
}

