/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.imap;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.protocols.imap.DecodingException;
import org.apache.james.protocols.imap.IMAPRequest;
import org.apache.james.protocols.imap.utils.EolInputStream;
import org.apache.james.protocols.imap.utils.FixedLengthInputStream;

public class IMAPRequestLineReader
extends ImapRequestLineReader {
    private final Iterator<ByteBuffer> args;
    private final byte[] prefix;
    private int pos = 0;
    private ByteBuffer curBuf;

    public IMAPRequestLineReader(IMAPRequest request) throws UnsupportedEncodingException {
        this.args = request.getArguments();
        this.prefix = (request.getTag() + " " + request.getCommand() + " ").getBytes("US-ASCII");
    }

    @Override
    public char nextChar() throws DecodingException {
        if (this.pos >= this.prefix.length) {
            if (this.curBuf == null || this.curBuf.remaining() == 0) {
                if (this.args.hasNext()) {
                    this.curBuf = this.args.next();
                } else {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected end of stream.");
                }
            }
            return (char)this.curBuf.get();
        }
        return (char)this.prefix[this.pos++];
    }

    @Override
    public InputStream read(int size, boolean extraCRLF) throws DecodingException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        FixedLengthInputStream in = new FixedLengthInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return IMAPRequestLineReader.this.consume();
            }
        }, size);
        if (extraCRLF) {
            return new EolInputStream(this, in);
        }
        return in;
    }

    @Override
    protected void commandContinuationRequest() throws DecodingException {
    }
}

