/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.FetchResponseBuilder;
import org.apache.james.imap.processor.fetch.MimePathImpl;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProcessor
extends AbstractMailboxProcessor<FetchRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchProcessor.class);

    public FetchProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(FetchRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(FetchRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        boolean useUids = request.isUseUids();
        IdRange[] idSet = request.getIdSet();
        FetchData fetch = request.getFetch();
        try {
            Long changedSince = fetch.getChangedSince();
            MessageManager mailbox = this.getSelectedMailbox(session);
            if (mailbox == null) {
                throw new MailboxException("Session not in SELECTED state");
            }
            boolean vanished = fetch.getVanished();
            if (vanished && !EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC")) {
                this.taggedBad(command, tag, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
                return;
            }
            if (vanished && changedSince == -1L) {
                this.taggedBad(command, tag, responder, HumanReadableText.QRESYNC_VANISHED_WITHOUT_CHANGEDSINCE);
                return;
            }
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            MessageManager.MetaData metaData = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
            if (fetch.getChangedSince() != -1L || fetch.isModSeq()) {
                this.condstoreEnablingCommand(session, responder, metaData, true);
            }
            ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
            for (IdRange range : idSet) {
                MessageRange messageSet = this.messageRange(session.getSelected(), range, useUids);
                if (messageSet == null) continue;
                MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
                MessageRange batchedMessageSet = MessageRange.range((MessageUid)normalizedMessageSet.getUidFrom(), (MessageUid)normalizedMessageSet.getUidTo());
                ranges.add(batchedMessageSet);
            }
            if (vanished) {
                this.respondVanished(mailboxSession, mailbox, ranges, changedSince, metaData, responder);
            }
            if (EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC")) {
                fetch.setUid(true);
            }
            this.processMessageRanges(session, mailbox, ranges, fetch, useUids, mailboxSession, responder);
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(command, tag, responder);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Fetch failed for mailbox {} because of invalid sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Fetch failed for mailbox {} and sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    protected void processMessageRanges(ImapSession session, MessageManager mailbox, List<MessageRange> ranges, FetchData fetch, boolean useUids, MailboxSession mailboxSession, ImapProcessor.Responder responder) throws MailboxException {
        FetchResponseBuilder builder = new FetchResponseBuilder(new EnvelopeBuilder());
        MessageResult.FetchGroup resultToFetch = this.getFetchGroup(fetch);
        for (MessageRange range : ranges) {
            MessageResultIterator messages = mailbox.getMessages(range, resultToFetch, mailboxSession);
            while (messages.hasNext()) {
                MessageResult result = (MessageResult)messages.next();
                if (fetch.isModSeq() && result.getModSeq() <= fetch.getChangedSince()) continue;
                try {
                    FetchResponse response = builder.build(fetch, result, mailbox, session, useUids);
                    responder.respond(response);
                }
                catch (MessageRangeException e) {
                    LOGGER.debug("Unable to find message with uid {}", (Object)result.getUid(), (Object)e);
                }
                catch (MailboxException e) {
                    LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getUid(), (Object)e);
                }
            }
            if (messages.getException() == null) continue;
            throw messages.getException();
        }
    }

    protected MessageResult.FetchGroup getFetchGroup(FetchData fetch) {
        Collection<BodyFetchElement> bodyElements;
        FetchGroupImpl result = new FetchGroupImpl();
        if (fetch.isEnvelope()) {
            result.or(256);
        }
        if (fetch.isBody() || fetch.isBodyStructure()) {
            result.or(1);
        }
        if ((bodyElements = fetch.getBodyElements()) != null) {
            for (BodyFetchElement element : bodyElements) {
                int sectionType = element.getSectionType();
                int[] path = element.getPath();
                boolean isBase = path == null || path.length == 0;
                switch (sectionType) {
                    case 5: {
                        if (isBase) {
                            this.addContent(result, path, isBase, 512);
                            break;
                        }
                        this.addContent(result, path, isBase, 4096);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.addContent(result, path, isBase, 256);
                        break;
                    }
                    case 1: {
                        this.addContent(result, path, isBase, 2048);
                        break;
                    }
                    case 0: {
                        this.addContent(result, path, isBase, 1024);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private void addContent(FetchGroupImpl result, int[] path, boolean isBase, int content) {
        if (isBase) {
            result.or(content);
        } else {
            MimePathImpl mimePath = new MimePathImpl(path);
            result.addPartContent((MessageResult.MimePath)mimePath, content);
        }
    }

    @Override
    protected Closeable addContextToMDC(FetchRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"FETCH").addContext("useUid", (Object)message.isUseUids()).addContext("idSet", (Object)IdRange.toString(message.getIdSet())).addContext("fetchedData", (Object)message.getFetch()).build();
    }
}

