/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.io.Closeable;
import java.io.IOException;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainedProcessor<M extends ImapMessage>
implements ImapProcessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractChainedProcessor.class);
    private final ImapProcessor next;
    private final Class<M> acceptableClass;

    public AbstractChainedProcessor(Class<M> acceptableClass, ImapProcessor next) {
        this.next = next;
        this.acceptableClass = acceptableClass;
    }

    @Override
    public void process(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        block11: {
            boolean isAcceptable = this.isAcceptable(message);
            if (isAcceptable) {
                ImapMessage acceptableMessage = message;
                try (Closeable closeable = this.addContextToMDC(acceptableMessage);){
                    try {
                        this.doProcess(acceptableMessage, responder, session);
                        break block11;
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Error while processing IMAP request", (Throwable)e);
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.next.process(message, responder, session);
        }
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        this.next.configure(imapConfiguration);
    }

    protected boolean isAcceptable(ImapMessage message) {
        return this.acceptableClass.isInstance(message);
    }

    protected abstract void doProcess(M var1, ImapProcessor.Responder var2, ImapSession var3);

    protected abstract Closeable addContextToMDC(M var1);
}

