/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.UnselectRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class UnselectProcessor
extends AbstractMailboxProcessor<UnselectRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> UNSELECT = Collections.unmodifiableList(Arrays.asList("UNSELECT"));

    public UnselectProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(UnselectRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(UnselectRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        if (session.getSelected() != null) {
            session.deselect();
            this.okComplete(command, tag, responder);
        } else {
            this.taggedBad(command, tag, responder, HumanReadableText.UNSELECT);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return UNSELECT;
    }

    @Override
    protected Closeable addContextToMDC(UnselectRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"UNSELECT").build();
    }
}

