/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.MyRightsRequest;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyRightsProcessor
extends AbstractMailboxProcessor<MyRightsRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyRightsProcessor.class);
    private static final List<String> CAPABILITIES = Collections.singletonList("ACL");

    public MyRightsProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(MyRightsRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(MyRightsRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.getMailbox(mailboxPath, mailboxSession);
            MailboxACL.Rfc4314Rights myRights = mailboxManager.myRights(mailboxPath, mailboxSession);
            if (!(myRights.contains(MailboxACL.Right.Lookup) || myRights.contains(MailboxACL.Right.Read) || myRights.contains(MailboxACL.Right.Insert) || myRights.contains(MailboxACL.Right.CreateMailbox) || myRights.contains(MailboxACL.Right.DeleteMailbox) || myRights.contains(MailboxACL.Right.Administer))) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else {
                MyRightsResponse myRightsResponse = new MyRightsResponse(mailboxName, myRights);
                responder.respond(myRightsResponse);
                this.okComplete(command, tag, responder);
            }
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            LOGGER.error("{} failed for mailbox {}", new Object[]{command.getName(), mailboxName, e});
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Closeable addContextToMDC(MyRightsRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"MYRIGHTS").addContext("mailbox", (Object)message.getMailboxName()).build();
    }
}

