/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.IdleRequest;
import org.apache.james.imap.message.response.ContinuationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.Registration;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.concurrent.NamedThreadFactory;

public class IdleProcessor
extends AbstractMailboxProcessor<IdleRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPS = ImmutableList.of((Object)"IDLE");
    public static final int DEFAULT_SCHEDULED_POOL_CORE_SIZE = 5;
    private static final String DONE = "DONE";
    private final EventBus eventBus;
    private TimeUnit heartbeatIntervalUnit;
    private long heartbeatInterval;
    private boolean enableIdle;
    private ScheduledExecutorService heartbeatExecutor;

    public IdleProcessor(ImapProcessor next, MailboxManager mailboxManager, EventBus eventBus, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IdleRequest.class, next, mailboxManager, factory, metricFactory);
        this.eventBus = eventBus;
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.heartbeatInterval = imapConfiguration.getIdleTimeInterval();
        this.heartbeatIntervalUnit = imapConfiguration.getIdleTimeIntervalUnit();
        this.enableIdle = imapConfiguration.isEnableIdle();
        if (this.enableIdle) {
            NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
            this.heartbeatExecutor = Executors.newScheduledThreadPool(5, (ThreadFactory)threadFactory);
        }
    }

    @Override
    protected void doProcess(IdleRequest message, final ImapSession session, final String tag, final ImapCommand command, final ImapProcessor.Responder responder) {
        SelectedMailbox sm = session.getSelected();
        final Registration registration = sm != null ? this.eventBus.register((MailboxListener)new IdleMailboxListener(session, responder), (RegistrationKey)new MailboxIdRegistrationKey(sm.getMailboxId())) : null;
        final AtomicBoolean idleActive = new AtomicBoolean(true);
        session.pushLineHandler(new ImapLineHandler(){

            @Override
            public void onLine(ImapSession session, byte[] data) {
                String line = data.length > 2 ? new String(data, 0, data.length - 2) : "";
                if (registration != null) {
                    registration.unregister();
                }
                session.popLineHandler();
                if (!IdleProcessor.DONE.equals(line.toUpperCase(Locale.US))) {
                    StatusResponse response = IdleProcessor.this.getStatusResponseFactory().taggedBad(tag, command, HumanReadableText.INVALID_COMMAND);
                    responder.respond(response);
                } else {
                    IdleProcessor.this.okComplete(command, tag, responder);
                }
                idleActive.set(false);
            }
        });
        if (this.enableIdle) {
            this.heartbeatExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                        StatusResponse response = IdleProcessor.this.getStatusResponseFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                        responder.respond(response);
                        IdleProcessor.this.heartbeatExecutor.schedule(this, IdleProcessor.this.heartbeatInterval, IdleProcessor.this.heartbeatIntervalUnit);
                    }
                }
            }, this.heartbeatInterval, this.heartbeatIntervalUnit);
        }
        responder.respond(new ContinuationResponse(HumanReadableText.IDLING));
        this.unsolicitedResponses(session, responder, false);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(IdleRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"IDLE").build();
    }

    private class IdleMailboxListener
    implements MailboxListener {
        private final ImapProcessor.Responder responder;
        private final ImapSession session;

        public IdleMailboxListener(ImapSession session, ImapProcessor.Responder responder) {
            this.session = session;
            this.responder = responder;
        }

        public boolean isHandling(Event event) {
            return event instanceof MailboxListener.Added || event instanceof MailboxListener.Expunged || event instanceof MailboxListener.FlagsUpdated;
        }

        public void event(Event event) {
            IdleProcessor.this.unsolicitedResponses(this.session, this.responder, false);
        }

        public MailboxListener.ExecutionMode getExecutionMode() {
            return MailboxListener.ExecutionMode.ASYNCHRONOUS;
        }
    }
}

