/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.AuthenticateRequest;
import org.apache.james.imap.message.request.IRAuthenticateRequest;
import org.apache.james.imap.message.response.AuthenticateResponse;
import org.apache.james.imap.processor.AbstractAuthProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticateProcessor
extends AbstractAuthProcessor<AuthenticateRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticateProcessor.class);
    private static final String PLAIN = "PLAIN";

    public AuthenticateProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(AuthenticateRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(AuthenticateRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String authType = request.getAuthType();
        if (authType.equalsIgnoreCase(PLAIN)) {
            if (session.isPlainAuthDisallowed() && !session.isTLSActive()) {
                this.no(command, tag, responder, HumanReadableText.DISABLED_LOGIN);
            } else if (request instanceof IRAuthenticateRequest) {
                IRAuthenticateRequest irRequest = (IRAuthenticateRequest)request;
                this.doPlainAuth(irRequest.getInitialClientResponse(), session, tag, command, responder);
            } else {
                responder.respond(new AuthenticateResponse());
                session.pushLineHandler((requestSession, data) -> {
                    String initialClientResponse = new String(data, 0, data.length - 2, Charset.forName("US-ASCII"));
                    this.doPlainAuth(initialClientResponse, requestSession, tag, command, responder);
                    requestSession.popLineHandler();
                });
            }
        } else {
            LOGGER.debug("Unsupported authentication mechanism '{}'", (Object)authType);
            this.no(command, tag, responder, HumanReadableText.UNSUPPORTED_AUTHENTICATION_MECHANISM);
        }
    }

    protected void doPlainAuth(String initialClientResponse, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = this.parseDelegationAttempt(initialClientResponse);
        if (authenticationAttempt.isDelegation()) {
            this.doAuthWithDelegation(authenticationAttempt, session, tag, command, responder, HumanReadableText.AUTHENTICATION_FAILED);
        } else {
            this.doAuth(authenticationAttempt, session, tag, command, responder, HumanReadableText.AUTHENTICATION_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAuthProcessor.AuthenticationAttempt parseDelegationAttempt(String initialClientResponse) {
        String userpass = new String(Base64.getDecoder().decode(initialClientResponse));
        StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
        String token1 = authTokenizer.nextToken();
        String token2 = authTokenizer.nextToken();
        try {
            AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = AuthenticateProcessor.delegation(token1, token2, authTokenizer.nextToken());
            authTokenizer = null;
            return authenticationAttempt;
        }
        catch (NoSuchElementException ignored) {
            try {
                AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = AuthenticateProcessor.noDelegation(token1, token2);
                authTokenizer = null;
                return authenticationAttempt;
            }
            catch (Throwable throwable) {
                try {
                    authTokenizer = null;
                    throw throwable;
                }
                catch (Exception e) {
                    return AuthenticateProcessor.noDelegation(null, null);
                }
            }
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        ArrayList<String> caps = new ArrayList<String>();
        if (!session.isPlainAuthDisallowed() || session.isTLSActive()) {
            caps.add("AUTH=PLAIN");
        }
        caps.add("SASL-IR");
        return ImmutableList.copyOf(caps);
    }

    @Override
    protected Closeable addContextToMDC(AuthenticateRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"AUTHENTICATE").addContext("authType", (Object)message.getAuthType()).build();
    }
}

