/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.message.request.AbstractImapRequest;

public class StoreRequest
extends AbstractImapRequest {
    private final IdRange[] idSet;
    private final Flags flags;
    private final boolean useUids;
    private final boolean silent;
    private final boolean signedMinus;
    private final boolean signedPlus;
    private final long unchangedSince;

    public StoreRequest(ImapCommand command, IdRange[] idSet, boolean silent, Flags flags, boolean useUids, String tag, Boolean sign, long unchangedSince) {
        super(tag, command);
        this.idSet = idSet;
        this.silent = silent;
        this.flags = flags;
        this.useUids = useUids;
        if (sign == null) {
            this.signedMinus = false;
            this.signedPlus = false;
        } else if (sign.booleanValue()) {
            this.signedMinus = false;
            this.signedPlus = true;
        } else {
            this.signedMinus = true;
            this.signedPlus = false;
        }
        this.unchangedSince = unchangedSince;
    }

    public final boolean isSilent() {
        return this.silent;
    }

    public final boolean isSignedMinus() {
        return this.signedMinus;
    }

    public final boolean isSignedPlus() {
        return this.signedPlus;
    }

    public final Flags getFlags() {
        return this.flags;
    }

    public final IdRange[] getIdSet() {
        return this.idSet;
    }

    public final boolean isUseUids() {
        return this.useUids;
    }

    public final long getUnchangedSince() {
        return this.unchangedSince;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("STORE ");
        if (this.isUseUids()) {
            buffer.append("UID ");
        }
        if (this.isSilent()) {
            buffer.append("SILENT ");
        }
        if (this.isSignedPlus()) {
            buffer.append("+ ");
        }
        if (this.isSignedMinus()) {
            buffer.append("- ");
        }
        if (this.flags.contains(Flags.Flag.ANSWERED)) {
            buffer.append(" ANSWERED");
        }
        if (this.flags.contains(Flags.Flag.DELETED)) {
            buffer.append(" DELETED");
        }
        if (this.flags.contains(Flags.Flag.FLAGGED)) {
            buffer.append(" FLAGGED");
        }
        if (this.flags.contains(Flags.Flag.DRAFT)) {
            buffer.append(" DRAFT");
        }
        if (this.flags.contains(Flags.Flag.SEEN)) {
            buffer.append(" SEEN");
        }
        if (this.flags.contains(Flags.Flag.RECENT)) {
            buffer.append(" RECEN");
        }
        return buffer.toString();
    }
}

