/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import java.io.IOException;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;

public class ResponseEncoder
implements ImapProcessor.Responder {
    private final ImapEncoder encoder;
    private final ImapSession session;
    private final ImapResponseComposer composer;
    private IOException failure;

    public ResponseEncoder(ImapEncoder encoder, ImapResponseComposer composer, ImapSession session) {
        this.encoder = encoder;
        this.composer = composer;
        this.session = session;
    }

    @Override
    public void respond(ImapResponseMessage message) {
        try {
            this.encoder.encode(message, this.composer, this.session);
        }
        catch (IOException failure) {
            this.failure = failure;
        }
    }

    public final IOException getFailure() {
        return this.failure;
    }
}

