/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.Locales;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ContinuationResponse;

public class ContinuationResponseEncoder
extends AbstractChainedImapEncoder {
    private final Localizer localizer;

    public ContinuationResponseEncoder(ImapEncoder next, Localizer localizer) {
        super(next);
        this.localizer = localizer;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        ContinuationResponse response = (ContinuationResponse)acceptableMessage;
        String message = response.getData() != null ? response.getData() : this.asString(response.getTextKey(), session);
        composer.continuationResponse(message);
    }

    private String asString(HumanReadableText text, ImapSession session) {
        return this.localizer.localize(text, new Locales(new ArrayList<Locale>(), null));
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof ContinuationResponse;
    }
}

