/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.ExpungeRequest;
import org.apache.james.protocols.imap.DecodingException;

public class ExpungeCommandParser
extends AbstractUidCommandParser {
    public ExpungeCommandParser() {
        super(ImapCommand.selectedStateCommand("EXPUNGE"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] uidSet = null;
        if (useUids) {
            uidSet = request.parseIdRange(session);
        }
        request.eol();
        return new ExpungeRequest(command, tag, uidSet);
    }
}

