/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.display;

import com.beetstra.jutf7.CharsetProvider;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CharsetUtil {
    private static final Set<String> charsetNames;
    private static final Set<Charset> charsets;
    private static final String X_MODIFIED_UTF_7 = "X-MODIFIED-UTF-7";
    private static final Charset X_MODIFIED_UTF_7_CHARSET;

    public static final Set<String> getAvailableCharsetNames() {
        return charsetNames;
    }

    public static final Set<Charset> getAvailableCharsets() {
        return charsets;
    }

    public static String decodeModifiedUTF7(String string) {
        return X_MODIFIED_UTF_7_CHARSET.decode(ByteBuffer.wrap(string.getBytes())).toString();
    }

    public static String encodeModifiedUTF7(String string) {
        ByteBuffer encode = X_MODIFIED_UTF_7_CHARSET.encode(string);
        return new String(encode.array(), 0, encode.remaining());
    }

    static {
        X_MODIFIED_UTF_7_CHARSET = new CharsetProvider().charsetForName(X_MODIFIED_UTF_7);
        HashSet<String> cNames = new HashSet<String>();
        HashSet<Charset> sets = new HashSet<Charset>();
        for (Charset charset : Charset.availableCharsets().values()) {
            Set<String> aliases = charset.aliases();
            cNames.add(charset.name());
            cNames.addAll(aliases);
            sets.add(charset);
        }
        charsetNames = Collections.unmodifiableSet(cNames);
        charsets = Collections.unmodifiableSet(sets);
    }
}

