/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SerialiseToHTTP
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialiseToHTTP.class);
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private String messageKeyName = "message";
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        String m = this.getInitParameter("MessageKeyName");
        if (m != null) {
            this.messageKeyName = m;
        }
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("I will attempt to deliver serialised messages to " + targetUrl + " as " + this.messageKeyName + ". " + (this.parameterKey == null || this.parameterKey.length() < 2 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
        }
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            String serialisedMessage = this.getSerialisedMessage(message);
            NameValuePair[] nameValuePairs = this.getNameValuePairs(serialisedMessage);
            String result = this.httpPost(nameValuePairs);
            if (this.passThrough) {
                this.addHeader(mail, result == null || result.length() == 0, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (IOException | MessagingException me) {
            LOGGER.error("Messaging exception", me);
            this.addHeader(mail, false, me.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-toHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-toHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException me) {
            LOGGER.error("Messaging exception", (Throwable)me);
        }
    }

    private String getSerialisedMessage(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        message.writeTo((OutputStream)os);
        return os.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String httpPost(NameValuePair[] data) {
        RequestBuilder requestBuilder = RequestBuilder.post((String)this.url);
        if (data.length > 1 && data[1] != null) {
            requestBuilder.addParameter(data[1].getName(), data[1].getValue());
            LOGGER.debug("{}::{}", (Object)data[1].getName(), (Object)data[1].getValue());
        }
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String string;
            block20: {
                CloseableHttpResponse clientResponse;
                block18: {
                    String string2;
                    block19: {
                        clientResponse = client.execute(requestBuilder.build());
                        try {
                            if (clientResponse.getStatusLine().getStatusCode() == 200) break block18;
                            LOGGER.debug("POST failed: {}", (Object)clientResponse.getStatusLine());
                            string2 = clientResponse.getStatusLine().toString();
                            if (clientResponse == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (clientResponse != null) {
                                try {
                                    clientResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        clientResponse.close();
                    }
                    return string2;
                }
                string = null;
                if (clientResponse == null) break block20;
                clientResponse.close();
            }
            return string;
        }
        catch (ClientProtocolException e) {
            LOGGER.error("Fatal protocol violation: ", (Throwable)e);
            return "Fatal protocol violation: " + e.getMessage();
        }
        catch (IOException e) {
            LOGGER.debug("Fatal transport error: ", (Throwable)e);
            return "Fatal transport error: " + e.getMessage();
        }
    }

    private NameValuePair[] getNameValuePairs(String message) throws UnsupportedEncodingException {
        int l = 1;
        if (this.parameterKey != null && this.parameterKey.length() > 0) {
            l = 2;
        }
        BasicNameValuePair[] data = new BasicNameValuePair[l];
        data[0] = new BasicNameValuePair(this.messageKeyName, message);
        if (l == 2) {
            data[1] = new BasicNameValuePair(this.parameterKey, this.parameterValue);
        }
        return data;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

