/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;

public class RemoveMimeHeader
extends GenericMailet {
    private List<String> headers;

    public void init() throws MailetException {
        String header = this.getInitParameter("name");
        if (header == null) {
            throw new MailetException("Invalid config. Please specify atleast one name");
        }
        this.headers = ImmutableList.copyOf((Iterable)Splitter.on((String)",").split((CharSequence)header));
    }

    public String getMailetInfo() {
        return "RemoveMimeHeader Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        for (String header : this.headers) {
            message.removeHeader(header);
        }
        this.removeSpecific(mail);
        message.saveChanges();
    }

    protected void removeSpecific(Mail mail) {
        mail.getPerRecipientSpecificHeaders().getRecipientsWithSpecificHeaders().stream().collect(Collectors.toList()).forEach(recipient -> {
            Iterator it = mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient).iterator();
            while (it.hasNext()) {
                PerRecipientHeaders.Header next = (PerRecipientHeaders.Header)it.next();
                if (!this.headers.contains(next.getName())) continue;
                it.remove();
            }
        });
    }
}

