/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ClamAVScan
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVScan.class);
    private static final int DEFAULT_PORT = 3310;
    private static final int DEFAULT_MAX_PINGS = 6;
    private static final int DEFAULT_PING_INTERVAL_MILLI = 30000;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final String STREAM_PORT_STRING = "PORT ";
    private static final String FOUND_STRING = "FOUND";
    private static final AttributeName MAIL_ATTRIBUTE_NAME = AttributeName.of((String)"org.apache.james.infected");
    private static final String HEADER_NAME = "X-MessageIsInfected";
    private boolean debug;
    private String host;
    private int port;
    private int maxPings;
    private int pingIntervalMilli;
    private int streamBufferSize;
    private InetAddress[] addresses;
    private int nextAddressIndex;

    public String getMailetInfo() {
        return "Antivirus Check using ClamAV (CLAMD)";
    }

    protected String[] getAllowedInitParameters() {
        return new String[]{"debug", "host", "port", "maxPings", "pingIntervalMilli", "streamBufferSize"};
    }

    protected void initDebug() {
        String debugParam = this.getInitParameter("debug");
        this.setDebug(debugParam == null ? false : Boolean.valueOf(debugParam));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void initHost() throws UnknownHostException {
        this.setHost(this.getInitParameter("host"));
        if (this.isDebug()) {
            LOGGER.debug("host: {}", (Object)this.getHost());
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) throws UnknownHostException {
        this.host = host;
        this.setAddresses(InetAddress.getAllByName(host));
        this.nextAddressIndex = 0;
    }

    protected void initPort() {
        String portParam = this.getInitParameter("port");
        this.setPort(portParam == null ? 3310 : Integer.parseInt(portParam));
        if (this.isDebug()) {
            LOGGER.debug("port: {}", (Object)this.getPort());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void initMaxPings() {
        String maxPingsParam = this.getInitParameter("maxPings");
        this.setMaxPings(maxPingsParam == null ? 6 : Integer.parseInt(maxPingsParam));
        if (this.isDebug()) {
            LOGGER.debug("maxPings: {}", (Object)this.getMaxPings());
        }
    }

    public int getMaxPings() {
        return this.maxPings;
    }

    public void setMaxPings(int maxPings) {
        this.maxPings = maxPings;
    }

    protected void initPingIntervalMilli() {
        String pingIntervalMilliParam = this.getInitParameter("pingIntervalMilli");
        this.setPingIntervalMilli(pingIntervalMilliParam == null ? 30000 : Integer.parseInt(pingIntervalMilliParam));
        if (this.isDebug()) {
            LOGGER.debug("pingIntervalMilli: {}", (Object)this.getPingIntervalMilli());
        }
    }

    public int getPingIntervalMilli() {
        return this.pingIntervalMilli;
    }

    public void setPingIntervalMilli(int pingIntervalMilli) {
        this.pingIntervalMilli = pingIntervalMilli;
    }

    protected void initStreamBufferSize() {
        String streamBufferSizeParam = this.getInitParameter("streamBufferSize");
        this.setStreamBufferSize(streamBufferSizeParam == null ? 8192 : Integer.parseInt(streamBufferSizeParam));
        if (this.isDebug()) {
            LOGGER.debug("streamBufferSize: {}", (Object)this.getStreamBufferSize());
        }
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public void setStreamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
    }

    protected InetAddress getAddresses(int index) {
        return this.addresses[index];
    }

    protected InetAddress[] getAddresses() {
        return this.addresses;
    }

    protected void setAddresses(InetAddress[] addresses) {
        this.addresses = addresses;
    }

    protected synchronized InetAddress getNextAddress() {
        InetAddress address = this.getAddresses(this.nextAddressIndex);
        ++this.nextAddressIndex;
        if (this.nextAddressIndex >= this.getAddressesCount()) {
            this.nextAddressIndex = 0;
        }
        return address;
    }

    public int getAddressesCount() {
        return this.getAddresses().length;
    }

    protected Socket getClamdSocket() throws MessagingException {
        HashSet<InetAddress> usedAddresses = new HashSet<InetAddress>(this.getAddressesCount());
        while (true) {
            if (usedAddresses.size() >= this.getAddressesCount()) {
                String logText = "Unable to connect to CLAMD. All addresses failed.";
                LOGGER.debug("{} Giving up.", (Object)logText);
                throw new MessagingException(logText);
            }
            InetAddress address = this.getNextAddress();
            if (!usedAddresses.add(address)) continue;
            try {
                return new Socket(address, this.getPort());
            }
            catch (IOException ioe) {
                LOGGER.error("Exception caught acquiring main socket to CLAMD on {} on port {}: ", new Object[]{address, this.getPort(), ioe});
                this.getNextAddress();
                continue;
            }
            break;
        }
    }

    public void init() throws MessagingException {
        this.checkInitParameters(this.getAllowedInitParameters());
        try {
            this.initDebug();
            if (this.isDebug()) {
                LOGGER.debug("Initializing");
            }
            this.initHost();
            this.initPort();
            this.initMaxPings();
            this.initPingIntervalMilli();
            this.initStreamBufferSize();
            if (this.getMaxPings() > 0) {
                this.ping();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception thrown", (Throwable)e);
            throw new MessagingException("Exception thrown", e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getAttribute(MAIL_ATTRIBUTE_NAME).isPresent()) {
            return;
        }
        MimeMessage mimeMessage = mail.getMessage();
        if (mimeMessage == null) {
            LOGGER.debug("Null MimeMessage. Will send to ghost");
            this.logMailInfo(mail);
            mail.setState("ghost");
            return;
        }
        Socket clamdSocket = this.getClamdSocket();
        try (Socket socket = clamdSocket;
             BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ASCII"));
             PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);){
            writer.println("STREAM");
            writer.flush();
            int streamPort = this.getStreamPortFromAnswer(reader.readLine());
            try (Socket streamSocket = new Socket(socket.getInetAddress(), streamPort);
                 BufferedOutputStream bos = new BufferedOutputStream(streamSocket.getOutputStream(), this.getStreamBufferSize());){
                String answer;
                mimeMessage.writeTo((OutputStream)bos);
                bos.flush();
                bos.close();
                streamSocket.close();
                boolean virusFound = false;
                String logMessage = "";
                while ((answer = reader.readLine()) != null) {
                    if (!(answer = answer.trim()).substring(answer.length() - FOUND_STRING.length()).equals(FOUND_STRING)) continue;
                    virusFound = true;
                    logMessage = answer + " (by CLAMD on " + socket.getInetAddress() + ")";
                    LOGGER.debug(logMessage);
                }
                reader.close();
                writer.close();
                if (virusFound) {
                    String errorMessage = mail.getErrorMessage();
                    errorMessage = errorMessage == null ? "" : errorMessage + "\r\n";
                    StringBuilder sb = new StringBuilder(errorMessage);
                    sb.append(logMessage).append("\r\n");
                    this.logMailInfo(mail);
                    this.logMessageInfo(mimeMessage);
                    mail.setAttribute(this.makeAttribute(true));
                    mail.setErrorMessage(sb.toString());
                    mimeMessage.setHeader(HEADER_NAME, "true");
                } else {
                    if (this.isDebug()) {
                        LOGGER.debug("OK (by CLAMD on {})", (Object)socket.getInetAddress());
                    }
                    mail.setAttribute(this.makeAttribute(false));
                    mimeMessage.setHeader(HEADER_NAME, "false");
                }
                try {
                    this.saveChanges(mimeMessage);
                }
                catch (Exception ex) {
                    LOGGER.error("Exception caught while saving changes (header) to the MimeMessage. Ignoring ...", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception caught calling CLAMD on {}: {}", new Object[]{clamdSocket.getInetAddress(), ex.getMessage(), ex});
            throw new MessagingException("Exception caught", ex);
        }
    }

    private Attribute makeAttribute(boolean value) {
        return new Attribute(MAIL_ATTRIBUTE_NAME, AttributeValue.of((Boolean)value));
    }

    protected void ping() throws Exception {
        for (int i = 0; i < this.getAddressesCount(); ++i) {
            this.ping(this.getAddresses(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping(InetAddress address) throws Exception {
        Socket socket = null;
        int ping = 1;
        while (true) {
            if (this.isDebug()) {
                LOGGER.debug("Trial #{}/{} - creating socket connected to {} on port {}", new Object[]{ping, this.getMaxPings(), address, this.getPort()});
            }
            try {
                socket = new Socket(address, this.getPort());
            }
            catch (ConnectException ce) {
                LOGGER.debug("Trial #{}/{} - exception caught while creating socket connected to {} on port {}", new Object[]{ping, this.getMaxPings(), address, this.getPort(), ce});
                if (++ping > this.getMaxPings()) break;
                LOGGER.debug("Waiting {} milliseconds before retrying ...", (Object)this.getPingIntervalMilli());
                Thread.sleep(this.getPingIntervalMilli());
                continue;
            }
            break;
        }
        if (socket == null) {
            throw new ConnectException("maxPings exceeded: " + this.getMaxPings() + ". Giving up. The clamd daemon seems not to be running");
        }
        try {
            String answer;
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ASCII"));
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            LOGGER.debug("Sending: \"PING\" to {} ...", (Object)address);
            writer.println("PING");
            writer.flush();
            boolean pongReceived = false;
            while ((answer = reader.readLine()) != null) {
                answer = answer.trim();
                LOGGER.debug("Received: \"{}\"", (Object)answer);
                if (!(answer = answer.trim()).equals("PONG")) continue;
                pongReceived = true;
            }
            reader.close();
            writer.close();
            if (!pongReceived) {
                throw new ConnectException("Bad answer from \"PING\" probe: expecting \"PONG\"");
            }
        }
        finally {
            socket.close();
        }
    }

    protected final int getStreamPortFromAnswer(String answer) throws ConnectException {
        int port = -1;
        if (answer != null && answer.startsWith(STREAM_PORT_STRING)) {
            String portSubstring = answer.substring(STREAM_PORT_STRING.length());
            try {
                port = Integer.parseInt(portSubstring);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Can not parse port from substring {}", (Object)portSubstring);
            }
        }
        if (port <= 0) {
            throw new ConnectException("\"PORT nn\" expected - unable to parse: \"" + answer + "\"");
        }
        return port;
    }

    protected final void saveChanges(MimeMessage message) throws MessagingException {
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
    }

    private void logMailInfo(Mail mail) {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sout = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)sout, true);
            out.print("Mail details:");
            out.print(" MAIL FROM: " + mail.getMaybeSender().asString());
            Iterator rcptTo = mail.getRecipients().iterator();
            out.print(", RCPT TO: " + rcptTo.next());
            while (rcptTo.hasNext()) {
                out.print(", " + rcptTo.next());
            }
            LOGGER.debug(sout.toString());
        }
    }

    private void logMessageInfo(MimeMessage mimeMessage) {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sout = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)sout, true);
            out.println("MimeMessage details:");
            try {
                String[] rcpts;
                String[] sender;
                if (mimeMessage.getSubject() != null) {
                    out.println("  Subject: " + mimeMessage.getSubject());
                }
                if (mimeMessage.getSentDate() != null) {
                    out.println("  Sent date: " + mimeMessage.getSentDate());
                }
                if ((sender = mimeMessage.getHeader("From")) != null) {
                    out.print("  From: ");
                    for (String aSender : sender) {
                        out.print(aSender + " ");
                    }
                    out.println();
                }
                if ((rcpts = mimeMessage.getHeader("To")) != null) {
                    out.print("  To: ");
                    for (String rcpt : rcpts) {
                        out.print(rcpt + " ");
                    }
                    out.println();
                }
                if ((rcpts = mimeMessage.getHeader("Cc")) != null) {
                    out.print("  CC: ");
                    for (String rcpt : rcpts) {
                        out.print(rcpt + " ");
                    }
                    out.println();
                }
                out.print("  Size (in bytes): " + mimeMessage.getSize());
                if (mimeMessage.getLineCount() >= 0) {
                    out.print(", Number of lines: " + mimeMessage.getLineCount());
                }
            }
            catch (MessagingException me) {
                LOGGER.error("Exception caught reporting message details", (Throwable)me);
            }
            LOGGER.debug(sout.toString());
        }
    }
}

