/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.hook;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxDeliverToRecipientHandler
implements DeliverToRecipientHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxDeliverToRecipientHandler.class);
    private UsersRepository users;
    private MailboxManager mailboxManager;

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Inject
    public final void setMailboxManager(@Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
        try {
            String username = this.users.getUser(recipient);
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mailboxSession);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            if (!this.mailboxManager.mailboxExists(inbox, mailboxSession)) {
                Optional mailboxId = this.mailboxManager.createMailbox(inbox, mailboxSession);
                LOGGER.info("Provisioning INBOX. {} created.", (Object)mailboxId);
            }
            this.mailboxManager.getMailbox(MailboxPath.inbox((MailboxSession)mailboxSession), mailboxSession).appendMessage(MessageManager.AppendCommand.builder().recent().build(envelope.getMessageInputStream()), mailboxSession);
            this.mailboxManager.endProcessingRequest(mailboxSession);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received").build();
        }
        catch (IOException | MailboxException | UsersRepositoryException e) {
            LOGGER.error("Unexpected error handling DATA stream", e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpDescription(" Temporary error deliver message to " + recipient).build();
        }
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

