/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.mime4j.util.MimeUtil;

public class SearchUtil {
    private static final String FWD_PARENS = "(fwd)";
    private static final String SUBJ_FWD_HDR = "[fwd:";
    private static final String SUBJ_FWD_TRL = "]";
    private static final String RE = "re";
    private static final String FWD = "fwd";
    private static final String FW = "fw";
    private static final char WS = ' ';
    private static final char OPEN_SQUARE_BRACKED = '[';
    private static final char CLOSE_SQUARE_BRACKED = ']';
    private static final char COLON = ':';
    private static final Charset UTF8 = Charset.forName("UTF8");

    public static String getDisplayAddress(Mailbox mailbox) {
        String display = mailbox.getName();
        if (display == null || display.length() < 1) {
            String localPart = mailbox.getLocalPart();
            String domainPart = mailbox.getDomain();
            if (domainPart != null && domainPart.length() > 0) {
                return localPart + "@" + domainPart;
            }
            return localPart;
        }
        return display;
    }

    public static String getDisplayAddress(String headerValue) {
        AddressList addressList = LenientAddressParser.DEFAULT.parseAddressList((CharSequence)MimeUtil.unfold((String)headerValue));
        if (addressList != null && !addressList.isEmpty()) {
            MailboxList mList;
            Group group;
            Address address = addressList.get(0);
            if (address instanceof Mailbox) {
                return SearchUtil.getDisplayAddress((Mailbox)address);
            }
            if (address instanceof Group && (group = (Group)address) != null && (mList = group.getMailboxes()) != null && !mList.isEmpty()) {
                return SearchUtil.getDisplayAddress(mList.get(0));
            }
        }
        return "";
    }

    public static String getMailboxAddress(Mailbox mailbox) {
        return mailbox.getLocalPart();
    }

    public static String getMailboxAddress(String headerValue) {
        AddressList aList = LenientAddressParser.DEFAULT.parseAddressList((CharSequence)headerValue);
        for (Address address : aList) {
            MailboxList mList;
            int a;
            if (address instanceof Mailbox) {
                Mailbox m = (Mailbox)address;
                String mailboxName = m.getLocalPart();
                if (mailboxName == null) {
                    mailboxName = "";
                }
                return mailboxName;
            }
            if (!(address instanceof Group) || (a = 0) >= (mList = ((Group)address).getMailboxes()).size()) continue;
            String mailboxName = mList.get(a).getLocalPart();
            if (mailboxName == null) {
                mailboxName = "";
            }
            return mailboxName;
        }
        return "";
    }

    public static String getSerializedMessageIdIfSupportedByUnderlyingStorageOrNull(MailboxMessage mailboxMessage) {
        MessageId messageId = mailboxMessage.getMessageId();
        if (messageId != null && messageId.isSerializable()) {
            return messageId.serialize();
        }
        return null;
    }

    public static String getBaseSubject(String subject) {
        String decodedSubject = MimeUtil.unfold((String)DecoderUtil.decodeEncodedWords((String)subject, (DecodeMonitor)DecodeMonitor.SILENT));
        decodedSubject = new String(decodedSubject.getBytes(UTF8), UTF8);
        decodedSubject = decodedSubject.replaceAll("\t", " ").replaceAll("( ){2,}", " ");
        while (true) {
            boolean matchedInner;
            String subj;
            int decodedSubjectLength = decodedSubject.length();
            while (decodedSubjectLength > (subj = SearchUtil.removeSubTrailers(decodedSubject)).length()) {
                decodedSubject = subj;
                decodedSubjectLength = decodedSubject.length();
            }
            do {
                matchedInner = false;
                decodedSubjectLength = decodedSubject.length();
                if (decodedSubjectLength > (decodedSubject = SearchUtil.removeSubjLeaders(decodedSubject)).length()) {
                    matchedInner = true;
                    decodedSubjectLength = decodedSubject.length();
                }
                decodedSubjectLength = decodedSubject.length();
                String subj2 = SearchUtil.removeBlob(decodedSubject);
                if (subj2.length() <= 0 || decodedSubjectLength <= (decodedSubject = subj2).length()) continue;
                matchedInner = true;
                decodedSubjectLength = decodedSubject.length();
            } while (matchedInner);
            String lowcaseSubject = decodedSubject.toLowerCase(Locale.US);
            if (!lowcaseSubject.startsWith(SUBJ_FWD_HDR) || !lowcaseSubject.endsWith(SUBJ_FWD_TRL)) break;
            decodedSubject = decodedSubject.substring(SUBJ_FWD_HDR.length(), decodedSubject.length() - SUBJ_FWD_TRL.length());
            int n = decodedSubject.length();
        }
        return decodedSubject;
    }

    private static String removeSubjectBlob(String subject) {
        String subj = subject;
        while (subj.charAt(0) == '[') {
            int length = subj.length();
            subj = SearchUtil.removeBlob(subject);
            int i = 0;
            if (subj.length() > 0 && subj.charAt(i) == ']') {
                ++i;
            } else {
                return subject;
            }
            while (subj.charAt(i) == ' ') {
                ++i;
            }
            if (length != (subj = subj.substring(i)).length()) continue;
            return subj;
        }
        return subj;
    }

    private static String removeSubjLeaders(String subject) {
        int subString = 0;
        while (subject.charAt(subString) == ' ') {
            ++subString;
        }
        if (subString > 0) {
            return subject.substring(subString);
        }
        String subj = SearchUtil.removeSubjectBlob(subject);
        String lowCaseSubj = subj.toLowerCase(Locale.US);
        if (lowCaseSubj.startsWith(RE)) {
            subString = RE.length();
        } else if (lowCaseSubj.startsWith(FWD)) {
            subString = FWD.length();
        } else if (lowCaseSubj.startsWith(FW)) {
            subString = FW.length();
        } else {
            return subject;
        }
        while (subj.charAt(subString) == ' ') {
            ++subString;
        }
        if (subj.charAt(subString) == ':') {
            ++subString;
        } else {
            return subject;
        }
        while (subj.charAt(subString) == ' ') {
            ++subString;
        }
        return subj.substring(subString);
    }

    private static String removeSubTrailers(String decodedSubject) {
        char c;
        int subStringStart = 0;
        int subStringEnd = decodedSubject.length();
        int originalSize = decodedSubject.length();
        int curPos = originalSize - 1;
        while ((c = decodedSubject.charAt(curPos--)) == ' ') {
            --subStringEnd;
        }
        if (subStringEnd > FWD_PARENS.length() && decodedSubject.endsWith(FWD_PARENS)) {
            subStringEnd -= FWD_PARENS.length();
        }
        decodedSubject = decodedSubject.substring(subStringStart, subStringEnd);
        return decodedSubject;
    }

    private static String removeBlob(String subject) {
        int i = 0;
        int lastChar = 0;
        for (int a = 0; a < subject.length(); ++a) {
            char c = subject.charAt(a);
            lastChar = c;
            if (a != 0 && c == '[' || c == ']') break;
            ++i;
        }
        if (lastChar != 93) {
            return subject;
        }
        return subject.substring(++i);
    }

    public static Predicate<MessageId> distinct() {
        return new Predicate<MessageId>(){
            private final Set<MessageId> set = new HashSet<MessageId>();

            @Override
            public boolean test(MessageId input) {
                return this.set.add(input);
            }
        };
    }
}

