/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedSearchException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMessageSearchIndex.class);
    private static final Group GROUP = new LazyMessageSearchIndexGroup();
    private final ListeningMessageSearchIndex index;
    private final ConcurrentHashMap<MailboxId, Object> indexed = new ConcurrentHashMap();
    private final MailboxSessionMapperFactory factory;

    public LazyMessageSearchIndex(ListeningMessageSearchIndex index, MailboxSessionMapperFactory factory, SessionProvider sessionProvider) {
        super(factory, sessionProvider);
        this.index = index;
        this.factory = factory;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    @Override
    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.noneOf(MailboxManager.SearchCapabilities.class);
    }

    @Override
    public void add(MailboxSession session, Mailbox mailbox, MailboxMessage message) throws Exception {
        this.index.add(session, mailbox, message);
    }

    @Override
    public void delete(MailboxSession session, Mailbox mailbox, Collection<MessageUid> expungedUids) throws Exception {
        this.index.delete(session, mailbox, expungedUids);
    }

    @Override
    public void deleteAll(MailboxSession session, Mailbox mailbox) throws Exception {
        this.index.deleteAll(session, mailbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        MailboxId id = mailbox.getMailboxId();
        Object done = this.indexed.get(id);
        if (done == null) {
            done = new Object();
            Object oldDone = this.indexed.putIfAbsent(id, done);
            if (oldDone != null) {
                done = oldDone;
            }
            Object object = done;
            synchronized (object) {
                Iterator<MailboxMessage> messages = this.factory.getMessageMapper(session).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, -1);
                while (messages.hasNext()) {
                    MailboxMessage message = messages.next();
                    try {
                        this.add(session, mailbox, message);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to index message {} in mailbox {}", new Object[]{message.getUid(), mailbox.getName(), e});
                    }
                }
            }
        }
        return this.index.search(session, mailbox, searchQuery);
    }

    @Override
    public void update(MailboxSession session, Mailbox mailbox, List<UpdatedFlags> updatedFlagsList) throws Exception {
        this.index.update(session, mailbox, updatedFlagsList);
    }

    @Override
    public List<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) throws MailboxException {
        throw new UnsupportedSearchException();
    }

    public static class LazyMessageSearchIndexGroup
    extends Group {
    }
}

