/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.Map;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.core.quota.QuotaValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;

public class StoreQuotaManager
implements QuotaManager {
    private final CurrentQuotaManager currentQuotaManager;
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public StoreQuotaManager(CurrentQuotaManager currentQuotaManager, MaxQuotaManager maxQuotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.maxQuotaManager = maxQuotaManager;
    }

    public Quota<QuotaCount> getMessageQuota(QuotaRoot quotaRoot) throws MailboxException {
        Map maxMessageDetails = this.maxQuotaManager.listMaxMessagesDetails(quotaRoot);
        return Quota.builder().used((QuotaValue)this.currentQuotaManager.getCurrentMessageCount(quotaRoot)).computedLimit((QuotaValue)this.maxQuotaManager.getMaxMessage(maxMessageDetails).orElse(QuotaCount.unlimited())).limitsByScope(maxMessageDetails).build();
    }

    public Quota<QuotaSize> getStorageQuota(QuotaRoot quotaRoot) throws MailboxException {
        Map maxStorageDetails = this.maxQuotaManager.listMaxStorageDetails(quotaRoot);
        return Quota.builder().used((QuotaValue)this.currentQuotaManager.getCurrentStorage(quotaRoot)).computedLimit((QuotaValue)this.maxQuotaManager.getMaxStorage(maxStorageDetails).orElse(QuotaSize.unlimited())).limitsByScope(maxStorageDetails).build();
    }
}

