/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import javax.inject.Inject;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoMaxQuotaManager;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.quota.NoQuotaUpdater;
import org.apache.james.mailbox.store.quota.QuotaUpdater;

public class QuotaComponents {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaUpdater quotaUpdater;

    public static QuotaComponents disabled(SessionProvider sessionProvider, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        return new QuotaComponents(new NoMaxQuotaManager(), new NoQuotaManager(), (QuotaRootResolver)new DefaultUserQuotaRootResolver(sessionProvider, mailboxSessionMapperFactory), new NoQuotaUpdater());
    }

    @Inject
    public QuotaComponents(MaxQuotaManager maxQuotaManager, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, QuotaUpdater quotaUpdater) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.quotaUpdater = quotaUpdater;
    }

    public MaxQuotaManager getMaxQuotaManager() {
        return this.maxQuotaManager;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.quotaRootResolver;
    }

    public QuotaUpdater getQuotaUpdater() {
        return this.quotaUpdater;
    }
}

