/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class MessageUtils {
    private final MailboxSession mailboxSession;
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;

    public MessageUtils(MailboxSession mailboxSession, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        Preconditions.checkNotNull((Object)uidProvider);
        Preconditions.checkNotNull((Object)modSeqProvider);
        this.mailboxSession = mailboxSession;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    public long getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(this.mailboxSession, mailbox);
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.lastUid(this.mailboxSession, mailbox);
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.nextUid(this.mailboxSession, mailbox);
    }

    public long nextModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox);
    }

    public void enrichMessage(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        message.setUid(this.nextUid(mailbox));
        message.setModSeq(this.nextModSeq(mailbox));
    }

    public MessageChangedFlags updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, Iterator<MailboxMessage> messages) throws MailboxException {
        ImmutableList.Builder updatedFlags = ImmutableList.builder();
        ImmutableList.Builder changedFlags = ImmutableList.builder();
        long modSeq = this.nextModSeq(mailbox);
        while (messages.hasNext()) {
            MailboxMessage member = messages.next();
            Flags originalFlags = member.createFlags();
            member.setFlags(flagsUpdateCalculator.buildNewFlags(originalFlags));
            Flags newFlags = member.createFlags();
            if (UpdatedFlags.flagsChanged((Flags)originalFlags, (Flags)newFlags)) {
                member.setModSeq(modSeq);
                changedFlags.add((Object)member);
            }
            updatedFlags.add((Object)UpdatedFlags.builder().uid(member.getUid()).modSeq(member.getModSeq()).newFlags(newFlags).oldFlags(originalFlags).build());
        }
        return new MessageChangedFlags((Iterator<UpdatedFlags>)updatedFlags.build().iterator(), (List<MailboxMessage>)changedFlags.build());
    }

    public class MessageChangedFlags {
        private final Iterator<UpdatedFlags> updatedFlags;
        private final List<MailboxMessage> changedFlags;

        public MessageChangedFlags(Iterator<UpdatedFlags> updatedFlags, List<MailboxMessage> changedFlags) {
            this.updatedFlags = updatedFlags;
            this.changedFlags = changedFlags;
        }

        public Iterator<UpdatedFlags> getUpdatedFlags() {
            return this.updatedFlags;
        }

        public List<MailboxMessage> getChangedFlags() {
            return this.changedFlags;
        }
    }
}

