/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PreDeletionHooks {
    private static final int CONCURRENCY = 1;
    public static final PreDeletionHooks NO_PRE_DELETION_HOOK = new PreDeletionHooks((Set<PreDeletionHook>)ImmutableSet.of(), (MetricFactory)new NoopMetricFactory());
    static final String PRE_DELETION_HOOK_METRIC_NAME = "preDeletionHook";
    private final Set<PreDeletionHook> hooks;
    private final MetricFactory metricFactory;

    @Inject
    public PreDeletionHooks(Set<PreDeletionHook> hooks, MetricFactory metricFactory) {
        this.hooks = hooks;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> runHooks(PreDeletionHook.DeleteOperation deleteOperation) {
        return Flux.fromIterable(this.hooks).publishOn(Schedulers.elastic()).flatMap(hook -> this.metricFactory.runPublishingTimerMetric(PRE_DELETION_HOOK_METRIC_NAME, Mono.from((Publisher)hook.notifyDelete(deleteOperation))), 1).then();
    }
}

