/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.store.LazyMimeDescriptor;
import org.apache.james.mailbox.store.MimeDescriptorImpl;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.streaming.InputStreamContent;
import org.apache.james.mime4j.MimeException;

public class MessageResultImpl
implements MessageResult {
    private final Map<MessageResult.MimePath, PartContent> partsByPath = new HashMap<MessageResult.MimePath, PartContent>();
    private MimeDescriptor mimeDescriptor;
    private final MailboxMessage message;
    private HeadersImpl headers;
    private Content fullContent;
    private Content bodyContent;

    public MessageResultImpl(MailboxMessage message) throws IOException {
        this.message = message;
        this.headers = new HeadersImpl(message);
    }

    public MessageMetaData messageMetaData() {
        return this.message.metaData();
    }

    public MailboxId getMailboxId() {
        return this.message.getMailboxId();
    }

    public MessageUid getUid() {
        return this.messageMetaData().getUid();
    }

    public MessageId getMessageId() {
        return this.messageMetaData().getMessageId();
    }

    public Date getInternalDate() {
        return this.messageMetaData().getInternalDate();
    }

    public Flags getFlags() {
        return this.messageMetaData().getFlags();
    }

    public long getModSeq() {
        return this.messageMetaData().getModSeq();
    }

    public long getSize() {
        return this.messageMetaData().getSize();
    }

    public int compareTo(MessageResult that) {
        return this.getUid().compareTo(that.getUid());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUid()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MessageResultImpl) {
            MessageResultImpl that = (MessageResultImpl)obj;
            return this.headers.equals(that.headers) && this.message.equals(that.message);
        }
        return false;
    }

    public final Content getFullContent() throws IOException {
        if (this.fullContent == null) {
            this.fullContent = new InputStreamContent(this.message, InputStreamContent.Type.Full);
        }
        return this.fullContent;
    }

    public final Content getBody() throws IOException {
        if (this.bodyContent == null) {
            this.bodyContent = new InputStreamContent(this.message, InputStreamContent.Type.Body);
        }
        return this.bodyContent;
    }

    public String toString() {
        String TAB = " ";
        return "MessageResultImpl ( uid = " + this.getUid() + " " + "flags = " + this.getFlags() + " " + "size = " + this.getSize() + " " + "internalDate = " + this.getInternalDate() + ")";
    }

    public Content getBody(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getBody();
        return result;
    }

    public Content getMimeBody(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getMimeBody();
        return result;
    }

    public Content getFullContent(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getFull();
        return result;
    }

    public Iterator<MessageResult.Header> iterateHeaders(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Iterator<MessageResult.Header> result = partContent == null ? null : partContent.getHeaders();
        return result;
    }

    public Iterator<MessageResult.Header> iterateMimeHeaders(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Iterator<MessageResult.Header> result = partContent == null ? null : partContent.getMimeHeaders();
        return result;
    }

    public void setBodyContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setBody(content);
    }

    public void setMimeBodyContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeBody(content);
    }

    public void setFullContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setFull(content);
    }

    public void setHeaders(MessageResult.MimePath path, Iterator<MessageResult.Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setHeaders(headers);
    }

    public void setMimeHeaders(MessageResult.MimePath path, Iterator<MessageResult.Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeHeaders(headers);
    }

    private PartContent getPartContent(MessageResult.MimePath path) {
        PartContent result = this.partsByPath.get(path);
        if (result == null) {
            result = new PartContent();
            this.partsByPath.put(path, result);
        }
        return result;
    }

    public MimeDescriptor getMimeDescriptor() throws MailboxException {
        if (this.mimeDescriptor == null) {
            try {
                this.mimeDescriptor = MimeDescriptorImpl.isComposite(this.message.getMediaType()) ? MimeDescriptorImpl.build(this.getFullContent().getInputStream()) : new LazyMimeDescriptor(this, this.message);
            }
            catch (IOException | MimeException e) {
                throw new MailboxException("Unable to create the MimeDescriptor", e);
            }
        }
        return this.mimeDescriptor;
    }

    public Headers getHeaders() throws MailboxException {
        if (this.headers == null) {
            this.headers = new HeadersImpl(this.message);
        }
        return this.headers;
    }

    public List<MessageAttachment> getAttachments() throws MailboxException {
        return this.message.getAttachments();
    }

    private final class HeadersImpl
    implements Headers {
        private final Message msg;
        private List<MessageResult.Header> headers;

        public HeadersImpl(Message msg) {
            this.msg = msg;
        }

        public int hashCode() {
            return 741 + MessageResultImpl.this.message.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof HeadersImpl) {
                return this.msg.equals(((HeadersImpl)obj).msg);
            }
            return false;
        }

        public InputStream getInputStream() throws IOException {
            return this.msg.getHeaderContent();
        }

        public long size() {
            return this.msg.getHeaderOctets();
        }

        public Iterator<MessageResult.Header> headers() throws MailboxException {
            if (this.headers == null) {
                try {
                    this.headers = ResultUtils.createHeaders(MessageResultImpl.this.message);
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to parse headers", (Throwable)e);
                }
            }
            return this.headers.iterator();
        }
    }

    private static final class PartContent {
        private Content body;
        private Content mimeBody;
        private Content full;
        private Iterator<MessageResult.Header> headers;
        private Iterator<MessageResult.Header> mimeHeaders;
        private int content;

        private PartContent() {
        }

        public Content getBody() {
            return this.body;
        }

        public void setBody(Content body) {
            this.content |= 0x400;
            this.body = body;
        }

        public Content getMimeBody() {
            return this.mimeBody;
        }

        public void setMimeBody(Content mimeBody) {
            this.content |= 0x1000;
            this.mimeBody = mimeBody;
        }

        public Content getFull() {
            return this.full;
        }

        public void setFull(Content full) {
            this.content |= 0x200;
            this.full = full;
        }

        public Iterator<MessageResult.Header> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Iterator<MessageResult.Header> headers) {
            this.content |= 0x100;
            this.headers = headers;
        }

        public Iterator<MessageResult.Header> getMimeHeaders() {
            return this.mimeHeaders;
        }

        public void setMimeHeaders(Iterator<MessageResult.Header> mimeHeaders) {
            this.content |= 0x800;
            this.mimeHeaders = mimeHeaders;
        }
    }
}

