/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.AbstractMailboxPathLocker;

public final class JVMMailboxPathLocker
extends AbstractMailboxPathLocker {
    private final ConcurrentHashMap<MailboxPath, ReadWriteLock> paths = new ConcurrentHashMap();

    @Override
    protected void lock(MailboxSession session, MailboxPath path, boolean writeLock) throws MailboxException {
        ReadWriteLock storedLock;
        ReadWriteLock lock = this.paths.get(path);
        if (lock == null && (storedLock = this.paths.putIfAbsent(path, lock = new ReentrantReadWriteLock())) != null) {
            lock = storedLock;
        }
        this.getLock(lock, writeLock).lock();
    }

    @Override
    protected void unlock(MailboxSession session, MailboxPath path, boolean writeLock) throws MailboxException {
        ReadWriteLock lock = this.paths.get(path);
        if (lock != null) {
            this.getLock(lock, writeLock).unlock();
        }
    }

    private Lock getLock(ReadWriteLock lock, boolean writeLock) {
        Lock l = writeLock ? lock.writeLock() : lock.readLock();
        return l;
    }
}

