/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.probe.SieveProbe;
import org.apache.james.sieverepository.api.SieveRepositoryManagementMBean;

public class JmxSieveProbe
implements SieveProbe,
JmxProbe {
    private static final String SIEVEMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=sievemanagerbean";
    private SieveRepositoryManagementMBean sieveRepositoryManagement;

    @Override
    public JmxSieveProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.sieveRepositoryManagement = jmxc.retrieveBean(SieveRepositoryManagementMBean.class, SIEVEMANAGER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public long getSieveQuota() throws Exception {
        return this.sieveRepositoryManagement.getQuota();
    }

    public void setSieveQuota(long quota) throws Exception {
        this.sieveRepositoryManagement.setQuota(quota);
    }

    public void removeSieveQuota() throws Exception {
        this.sieveRepositoryManagement.removeQuota();
    }

    public long getSieveQuota(String user) throws Exception {
        return this.sieveRepositoryManagement.getQuota(user);
    }

    public void setSieveQuota(String user, long quota) throws Exception {
        this.sieveRepositoryManagement.setQuota(user, quota);
    }

    public void removeSieveQuota(String user) throws Exception {
        this.sieveRepositoryManagement.removeQuota(user);
    }

    public void addActiveSieveScript(String user, String name, String script) throws Exception {
        this.sieveRepositoryManagement.addActiveSieveScript(user, name, script);
    }

    public void addActiveSieveScriptFromFile(String user, String name, String path) throws Exception {
        this.sieveRepositoryManagement.addActiveSieveScriptFromFile(user, name, path);
    }
}

