/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.SerializableQuota;
import org.apache.james.mailbox.model.SerializableQuotaValue;
import org.apache.james.mailbox.probe.QuotaProbe;

public class JmxQuotaProbe
implements QuotaProbe,
JmxProbe {
    private static final String QUOTAMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=quotamanagerbean";
    private QuotaManagementMBean quotaManagement;

    @Override
    public JmxQuotaProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.quotaManagement = jmxc.retrieveBean(QuotaManagementMBean.class, QUOTAMANAGER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        return this.quotaManagement.getQuotaRoot(namespace, user, name);
    }

    public SerializableQuota<QuotaCount> getMessageCountQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMessageCountQuota(quotaRoot);
    }

    public SerializableQuota<QuotaSize> getStorageQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getStorageQuota(quotaRoot);
    }

    public SerializableQuotaValue<QuotaCount> getMaxMessageCount(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxMessageCount(quotaRoot);
    }

    public SerializableQuotaValue<QuotaSize> getMaxStorage(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxStorage(quotaRoot);
    }

    public SerializableQuotaValue<QuotaCount> getGlobalMaxMessageCount() throws MailboxException {
        return this.quotaManagement.getGlobalMaxMessageCount();
    }

    public SerializableQuotaValue<QuotaSize> getGlobalMaxStorage() throws MailboxException {
        return this.quotaManagement.getGlobalMaxStorage();
    }

    public void setMaxMessageCount(String quotaRoot, SerializableQuotaValue<QuotaCount> maxMessageCount) throws MailboxException {
        this.quotaManagement.setMaxMessageCount(quotaRoot, maxMessageCount);
    }

    public void setMaxStorage(String quotaRoot, SerializableQuotaValue<QuotaSize> maxSize) throws MailboxException {
        this.quotaManagement.setMaxStorage(quotaRoot, maxSize);
    }

    public void setGlobalMaxMessageCount(SerializableQuotaValue<QuotaCount> maxGlobalMessageCount) throws MailboxException {
        this.quotaManagement.setGlobalMaxMessageCount(maxGlobalMessageCount);
    }

    public void setGlobalMaxStorage(SerializableQuotaValue<QuotaSize> maxGlobalSize) throws MailboxException {
        this.quotaManagement.setGlobalMaxStorage(maxGlobalSize);
    }
}

