/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.smtp.AllButStartTlsLineChannelHandlerFactory;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.smtpserver.CoreCmdHandlerLoader;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.jmx.JMXHandlersLoader;
import org.apache.james.smtpserver.netty.SMTPChannelUpstreamHandler;
import org.apache.james.smtpserver.netty.SMTPServerMBean;
import org.apache.james.smtpserver.netty.SmtpMetrics;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPServer
extends AbstractProtocolAsyncServer
implements SMTPServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProtocolAsyncServer.class);
    public static final int AUTH_DISABLED = 0;
    public static final int AUTH_REQUIRED = 1;
    public static final int AUTH_ANNOUNCE = 2;
    private int authRequired = 0;
    private boolean heloEhloEnforcement = false;
    private String smtpGreeting = null;
    private NetMatcher authorizedNetworks = null;
    private long maxMessageSize = 0L;
    private final SMTPConfiguration theConfigData = new SMTPHandlerConfigurationDataImpl();
    private final SmtpMetrics smtpMetrics;
    private boolean addressBracketsEnforcement = true;
    private boolean verifyIdentity;
    private DNSService dns;
    private String authorizedAddresses;
    private SMTPChannelUpstreamHandler coreHandler;

    public SMTPServer(SmtpMetrics smtpMetrics) {
        this.smtpMetrics = smtpMetrics;
    }

    @Inject
    public void setDnsService(DNSService dns) {
        this.dns = dns;
    }

    protected void preInit() throws Exception {
        super.preInit();
        if (this.authorizedAddresses != null) {
            StringTokenizer st = new StringTokenizer(this.authorizedAddresses, ", ", false);
            ArrayList<String> networks = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String addr = st.nextToken();
                networks.add(addr);
            }
            this.authorizedNetworks = new NetMatcher(networks, this.dns);
        }
        SMTPProtocol transport = new SMTPProtocol(this.getProtocolHandlerChain(), this.theConfigData){

            public ProtocolSession newSession(ProtocolTransport transport) {
                return new ExtendedSMTPSession(SMTPServer.this.theConfigData, transport);
            }
        };
        this.coreHandler = new SMTPChannelUpstreamHandler((Protocol)transport, this.getEncryption(), this.smtpMetrics);
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        if (this.isEnabled()) {
            String authRequiredString = configuration.getString("authRequired", "false").trim().toLowerCase(Locale.US);
            this.authRequired = authRequiredString.equals("true") ? 1 : (authRequiredString.equals("announce") ? 2 : 0);
            if (this.authRequired != 0) {
                LOGGER.info("This SMTP server requires authentication.");
            } else {
                LOGGER.info("This SMTP server does not require authentication.");
            }
            this.authorizedAddresses = configuration.getString("authorizedAddresses", null);
            if (this.authRequired == 0 && this.authorizedAddresses == null) {
                this.authorizedAddresses = "0.0.0.0/0.0.0.0";
            }
            if (this.authorizedNetworks != null) {
                LOGGER.info("Authorized addresses: {}", (Object)this.authorizedNetworks);
            }
            this.maxMessageSize = configuration.getLong("maxmessagesize", this.maxMessageSize) * 1024L;
            if (this.maxMessageSize > 0L) {
                LOGGER.info("The maximum allowed message size is {} bytes.", (Object)this.maxMessageSize);
            } else {
                LOGGER.info("No maximum message size is enforced for this server.");
            }
            this.heloEhloEnforcement = configuration.getBoolean("heloEhloEnforcement", true);
            if (authRequiredString.equals("true")) {
                this.authRequired = 1;
            }
            this.smtpGreeting = configuration.getString("smtpGreeting", null);
            this.addressBracketsEnforcement = configuration.getBoolean("addressBracketsEnforcement", true);
            this.verifyIdentity = configuration.getBoolean("verifyIdentity", true);
        }
    }

    protected int getDefaultPort() {
        return 25;
    }

    public String getServiceType() {
        return "SMTP Service";
    }

    @Override
    public long getMaximalMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public boolean getAddressBracketsEnforcement() {
        return this.addressBracketsEnforcement;
    }

    @Override
    public boolean getHeloEhloEnforcement() {
        return this.heloEhloEnforcement;
    }

    protected String getDefaultJMXName() {
        return "smtpserver";
    }

    @Override
    public void setMaximalMessageSize(long maxSize) {
        this.maxMessageSize = maxSize;
    }

    @Override
    public void setAddressBracketsEnforcement(boolean enforceAddressBrackets) {
        this.addressBracketsEnforcement = enforceAddressBrackets;
    }

    @Override
    public void setHeloEhloEnforcement(boolean enforceHeloEHlo) {
        this.heloEhloEnforcement = enforceHeloEHlo;
    }

    @Override
    public String getHeloName() {
        return this.theConfigData.getHelloName();
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return this.coreHandler;
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new AllButStartTlsLineChannelHandlerFactory(8192);
    }

    public int getAuthRequired() {
        return this.authRequired;
    }

    public class SMTPHandlerConfigurationDataImpl
    implements SMTPConfiguration {
        public String getHelloName() {
            return SMTPServer.this.getHelloName();
        }

        public long getMaxMessageSize() {
            return SMTPServer.this.maxMessageSize;
        }

        public boolean isRelayingAllowed(String remoteIP) {
            boolean relayingAllowed = false;
            if (SMTPServer.this.authorizedNetworks != null) {
                relayingAllowed = SMTPServer.this.authorizedNetworks.matchInetNetwork(remoteIP);
            }
            return relayingAllowed;
        }

        public boolean useHeloEhloEnforcement() {
            return SMTPServer.this.heloEhloEnforcement;
        }

        public String getSMTPGreeting() {
            return SMTPServer.this.smtpGreeting;
        }

        public boolean useAddressBracketsEnforcement() {
            return SMTPServer.this.addressBracketsEnforcement;
        }

        public boolean isAuthRequired(String remoteIP) {
            boolean authRequired;
            if (SMTPServer.this.authRequired == 2) {
                return true;
            }
            boolean bl = authRequired = SMTPServer.this.authRequired != 0;
            if (SMTPServer.this.authorizedNetworks != null) {
                authRequired = authRequired && !SMTPServer.this.authorizedNetworks.matchInetNetwork(remoteIP);
            }
            return authRequired;
        }

        public boolean verifyIdentity() {
            return SMTPServer.this.verifyIdentity;
        }

        public String getGreeting() {
            return SMTPServer.this.smtpGreeting;
        }

        public String getSoftwareName() {
            return "JAMES SMTP Server ";
        }
    }
}

