/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailHandler
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMailHandler.class);
    private MailQueue queue;
    private MailQueueFactory<?> queueFactory;

    @Inject
    public void setMailQueueFactory(MailQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.queue = this.queueFactory.createQueue("spool");
    }

    public void destroy() {
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        LOGGER.debug("sending mail");
        try {
            this.queue.enQueue(mail);
            LOGGER.info("Successfully spooled mail {} from {} on {} for {}", new Object[]{mail.getName(), mail.getMaybeSender(), session.getRemoteAddress().getAddress(), mail.getRecipients()});
        }
        catch (MessagingException me) {
            LOGGER.error("Unknown error occurred while processing DATA.", (Throwable)me);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpDescription(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message.").build();
        }
        return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received").build();
    }
}

