/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class MailPriorityHandler
implements JamesMessageHook,
ProtocolHandler {
    private final Map<Domain, Integer> prioMap = new HashMap<Domain, Integer>();

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        Iterator rcpts = mail.getRecipients().iterator();
        Integer p = null;
        while (rcpts.hasNext()) {
            Integer prio;
            Domain domain = ((MailAddress)rcpts.next()).getDomain();
            if (domain == null || (prio = this.prioMap.get(domain)) == null) continue;
            if (p == null || prio > p) {
                p = prio;
            }
            if (p != 9) continue;
            break;
        }
        if (p != null) {
            mail.setAttribute(new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.of(p)));
        }
        return HookResult.DECLINED;
    }

    public void init(Configuration config) throws ConfigurationException {
        List entries = ((HierarchicalConfiguration)config).configurationsAt("priorityEntries.priorityEntry");
        for (HierarchicalConfiguration prioConf : entries) {
            Domain domain = Domain.of((String)prioConf.getString("domain"));
            int prio = prioConf.getInt("priority", 5);
            if (prio > 9 || prio < 0) {
                throw new ConfigurationException("configured priority must be >= 0 and <= 9");
            }
            this.prioMap.put(domain, prio);
        }
    }

    public void destroy() {
    }
}

