/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class UserReindexingTask
implements Task {
    public static final String USER_RE_INDEXING = "userReIndexing";
    public static final Function<Factory, TaskDTOModule<UserReindexingTask, UserReindexingTaskDTO>> MODULE = factory -> (TaskDTOModule)DTOModule.forDomainObject(UserReindexingTask.class).convertToDTO(UserReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(UserReindexingTaskDTO::of).typeName(USER_RE_INDEXING).withFactory(TaskDTOModule::new);
    private final ReIndexerPerformer reIndexerPerformer;
    private final User user;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public UserReindexingTask(ReIndexerPerformer reIndexerPerformer, User user) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.user = user;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(this.reprocessingContext, user);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.user, this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return USER_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer) {
            this.reIndexerPerformer = reIndexerPerformer;
        }

        public UserReindexingTask create(UserReindexingTaskDTO dto) {
            User user = User.fromUsername((String)dto.getUsername());
            return new UserReindexingTask(this.reIndexerPerformer, user);
        }
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final User user;

        AdditionalInformation(ReprocessingContext reprocessingContext, User user) {
            super(reprocessingContext);
            this.user = user;
        }

        public String getUser() {
            return this.user.asString();
        }
    }

    public static class UserReindexingTaskDTO
    implements TaskDTO {
        private final String type;
        private final String username;

        public static UserReindexingTaskDTO of(UserReindexingTask task, String type) {
            return new UserReindexingTaskDTO(type, task.user.asString());
        }

        private UserReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username) {
            this.type = type;
            this.username = username;
        }

        public String getType() {
            return this.type;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

