/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMessageReindexingTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleMessageReindexingTask.class);
    public static final String MESSAGE_RE_INDEXING = "messageReIndexing";
    public static final Function<Factory, TaskDTOModule<SingleMessageReindexingTask, SingleMessageReindexingTaskDTO>> MODULE = factory -> (TaskDTOModule)DTOModule.forDomainObject(SingleMessageReindexingTask.class).convertToDTO(SingleMessageReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(SingleMessageReindexingTaskDTO::of).typeName(MESSAGE_RE_INDEXING).withFactory(TaskDTOModule::new);
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final MessageUid uid;
    private final AdditionalInformation additionalInformation;

    @Inject
    SingleMessageReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId, MessageUid uid) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.uid = uid;
        this.additionalInformation = new AdditionalInformation(mailboxId, uid);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.handleMessageReIndexing(this.mailboxId, this.uid, new ReprocessingContext());
        }
        catch (MailboxException e) {
            LOGGER.warn("Error encounteres while reindexing {} : {}", new Object[]{this.mailboxId, this.uid, e});
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return MESSAGE_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public SingleMessageReindexingTask create(SingleMessageReindexingTaskDTO dto) {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(dto.getMailboxId());
            MessageUid uid = MessageUid.of((long)dto.getUid());
            return new SingleMessageReindexingTask(this.reIndexerPerformer, mailboxId, uid);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailboxId mailboxId;
        private final MessageUid uid;

        AdditionalInformation(MailboxId mailboxId, MessageUid uid) {
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }

        public long getUid() {
            return this.uid.asLong();
        }
    }

    public static class SingleMessageReindexingTaskDTO
    implements TaskDTO {
        private final String type;
        private final String mailboxId;
        private final long uid;

        private SingleMessageReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uid") long uid) {
            this.type = type;
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        public String getType() {
            return this.type;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public long getUid() {
            return this.uid;
        }

        public static SingleMessageReindexingTaskDTO of(SingleMessageReindexingTask task, String type) {
            return new SingleMessageReindexingTaskDTO(type, task.mailboxId.serialize(), task.uid.asLong());
        }
    }
}

