/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class SingleMailboxReindexingTask
implements Task {
    public static final String MAILBOX_RE_INDEXING = "mailboxReIndexing";
    public static final Function<Factory, TaskDTOModule<SingleMailboxReindexingTask, SingleMailboxReindexingTaskDTO>> MODULE = factory -> (TaskDTOModule)DTOModule.forDomainObject(SingleMailboxReindexingTask.class).convertToDTO(SingleMailboxReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(SingleMailboxReindexingTaskDTO::of).typeName(MAILBOX_RE_INDEXING).withFactory(TaskDTOModule::new);
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public SingleMailboxReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(mailboxId, this.reprocessingContext);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.mailboxId, this.reprocessingContext);
        }
        catch (Exception e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return MAILBOX_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public SingleMailboxReindexingTask create(SingleMailboxReindexingTaskDTO dto) {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(dto.getMailboxId());
            return new SingleMailboxReindexingTask(this.reIndexerPerformer, mailboxId);
        }
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final MailboxId mailboxId;

        AdditionalInformation(MailboxId mailboxId, ReprocessingContext reprocessingContext) {
            super(reprocessingContext);
            this.mailboxId = mailboxId;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }
    }

    public static class SingleMailboxReindexingTaskDTO
    implements TaskDTO {
        private final String type;
        private final String mailboxId;

        public static SingleMailboxReindexingTaskDTO of(SingleMailboxReindexingTask task, String typeName) {
            return new SingleMailboxReindexingTaskDTO(typeName, task.mailboxId.serialize());
        }

        public SingleMailboxReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId) {
            this.type = type;
            this.mailboxId = mailboxId;
        }

        public String getType() {
            return this.type;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }
    }
}

