/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Multimap;
import java.util.List;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;

public class SerializableReIndexingExecutionFailures {
    private final List<SerializableReIndexingFailure> failures;

    public static SerializableReIndexingExecutionFailures from(ReIndexingExecutionFailures reIndexingExecutionFailures) {
        return new SerializableReIndexingExecutionFailures((List)reIndexingExecutionFailures.failures().stream().map(failure -> new SerializableReIndexingFailure(failure.getMailboxId(), failure.getUid())).collect(Guavate.toImmutableList()));
    }

    public SerializableReIndexingExecutionFailures(List<SerializableReIndexingFailure> failures) {
        this.failures = failures;
    }

    @JsonValue
    public Multimap<String, SerializableReIndexingFailure> failures() {
        return (Multimap)this.failures.stream().collect(Guavate.toImmutableListMultimap(SerializableReIndexingFailure::getSerializedMailboxId));
    }

    public static class SerializableReIndexingFailure {
        private final MailboxId mailboxId;
        private final MessageUid uid;

        public SerializableReIndexingFailure(MailboxId mailboxId, MessageUid uid) {
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        @JsonIgnore
        public String getSerializedMailboxId() {
            return this.mailboxId.serialize();
        }

        public long getUid() {
            return this.uid.asLong();
        }
    }
}

