/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.mailbox.indexer.IndexingDetailInformation;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.SerializableReIndexingExecutionFailures;

public class ReprocessingContextInformation
implements TaskExecutionDetails.AdditionalInformation,
IndexingDetailInformation {
    private final ReprocessingContext reprocessingContext;

    ReprocessingContextInformation(ReprocessingContext reprocessingContext) {
        this.reprocessingContext = reprocessingContext;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reprocessingContext.successfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reprocessingContext.failedReprocessingMailCount();
    }

    @JsonIgnore
    public ReIndexingExecutionFailures failures() {
        return this.reprocessingContext.failures();
    }

    @JsonProperty(value="failures")
    public SerializableReIndexingExecutionFailures failuresAsJson() {
        return SerializableReIndexingExecutionFailures.from(this.failures());
    }
}

