/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.task.Task;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTask;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;
import org.apache.mailbox.tools.indexer.SingleMessageReindexingTask;
import org.apache.mailbox.tools.indexer.UserReindexingTask;

public class ReIndexerImpl
implements ReIndexer {
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mapperFactory;

    @Inject
    public ReIndexerImpl(ReIndexerPerformer reIndexerPerformer, MailboxManager mailboxManager, MailboxSessionMapperFactory mapperFactory) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxManager = mailboxManager;
        this.mapperFactory = mapperFactory;
    }

    public Task reIndex(MailboxPath path) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(path.getUser());
        MailboxId mailboxId = this.mailboxManager.getMailbox(path, mailboxSession).getId();
        return new SingleMailboxReindexingTask(this.reIndexerPerformer, mailboxId);
    }

    public Task reIndex(MailboxId mailboxId) throws MailboxException {
        this.validateIdExists(mailboxId);
        return new SingleMailboxReindexingTask(this.reIndexerPerformer, mailboxId);
    }

    public Task reIndex() {
        return new FullReindexingTask(this.reIndexerPerformer);
    }

    public Task reIndex(User user) {
        return new UserReindexingTask(this.reIndexerPerformer, user);
    }

    public Task reIndex(MailboxPath path, MessageUid uid) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(path.getUser());
        MailboxId mailboxId = this.mailboxManager.getMailbox(path, mailboxSession).getId();
        return new SingleMessageReindexingTask(this.reIndexerPerformer, mailboxId, uid);
    }

    public Task reIndex(MailboxId mailboxId, MessageUid uid) throws MailboxException {
        this.validateIdExists(mailboxId);
        return new SingleMessageReindexingTask(this.reIndexerPerformer, mailboxId, uid);
    }

    public Task reIndex(ReIndexingExecutionFailures previousFailures) {
        return new ErrorRecoveryIndexationTask(this.reIndexerPerformer, previousFailures);
    }

    private void validateIdExists(MailboxId mailboxId) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession("ReIndexingImap");
        this.mapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId);
    }
}

