/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.indexer.MessageIdReIndexer;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIdReIndexerImpl
implements MessageIdReIndexer {
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final ListeningMessageSearchIndex index;

    @Inject
    public MessageIdReIndexerImpl(MailboxManager mailboxManager, MailboxSessionMapperFactory mailboxSessionMapperFactory, ListeningMessageSearchIndex index) {
        this.mailboxManager = mailboxManager;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.index = index;
    }

    public Task reIndex(MessageId messageId) {
        return new MessageIdReIndexingTask(this.mailboxManager, this.mailboxSessionMapperFactory, this.index, messageId);
    }

    public static class MessageIdReIndexingTask
    implements Task {
        private static final Logger LOGGER = LoggerFactory.getLogger(MessageIdReIndexingTask.class);
        public static final String TYPE = "MessageIdReIndexingTask";
        private final MailboxManager mailboxManager;
        private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
        private final ListeningMessageSearchIndex index;
        private final MessageId messageId;
        private final AdditionalInformation additionalInformation;

        MessageIdReIndexingTask(MailboxManager mailboxManager, MailboxSessionMapperFactory mailboxSessionMapperFactory, ListeningMessageSearchIndex index, MessageId messageId) {
            this.mailboxManager = mailboxManager;
            this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
            this.index = index;
            this.messageId = messageId;
            this.additionalInformation = new AdditionalInformation(messageId);
        }

        public Task.Result run() {
            try {
                MailboxSession session = this.mailboxManager.createSystemSession("MessageIdReIndexerImpl");
                return this.mailboxSessionMapperFactory.getMessageIdMapper(session).find((Collection)ImmutableList.of((Object)this.messageId), MessageMapper.FetchType.Full).stream().map(mailboxMessage -> this.reIndex((MailboxMessage)mailboxMessage, session)).reduce(Task::combine).orElse(Task.Result.COMPLETED);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to re-index {}", (Object)this.messageId, (Object)e);
                return Task.Result.PARTIAL;
            }
        }

        public Task.Result reIndex(MailboxMessage mailboxMessage, MailboxSession session) {
            try {
                MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
                Mailbox mailbox = mailboxMapper.findMailboxById(mailboxMessage.getMailboxId());
                this.index.add(session, mailbox, mailboxMessage);
                return Task.Result.COMPLETED;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to re-index {} in {}", new Object[]{this.messageId, mailboxMessage.getMailboxId(), e});
                return Task.Result.PARTIAL;
            }
        }

        public String type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.additionalInformation);
        }

        public final class AdditionalInformation
        implements TaskExecutionDetails.AdditionalInformation {
            private final MessageId messageId;

            AdditionalInformation(MessageId messageId) {
                this.messageId = messageId;
            }

            public String getMessageId() {
                return this.messageId.serialize();
            }
        }
    }
}

