/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class FullReindexingTask
implements Task {
    public static final String FULL_RE_INDEXING = "FullReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReprocessingContextInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;
    public static final Function<Factory, TaskDTOModule<FullReindexingTask, FullReindexingTaskDTO>> MODULE = factory -> (TaskDTOModule)DTOModule.forDomainObject(FullReindexingTask.class).convertToDTO(FullReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter((task, type) -> new FullReindexingTaskDTO(type)).typeName(FULL_RE_INDEXING).withFactory(TaskDTOModule::new);

    @Inject
    public FullReindexingTask(ReIndexerPerformer reIndexerPerformer) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new ReprocessingContextInformation(this.reprocessingContext);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return FULL_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer) {
            this.reIndexerPerformer = reIndexerPerformer;
        }

        public FullReindexingTask create(FullReindexingTaskDTO dto) {
            return new FullReindexingTask(this.reIndexerPerformer);
        }
    }

    public static class FullReindexingTaskDTO
    implements TaskDTO {
        private final String type;

        public FullReindexingTaskDTO(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

