/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class ErrorRecoveryIndexationTask
implements Task {
    private static final String PREVIOUS_FAILURES_INDEXING = "ErrorRecoveryIndexation";
    public static final Function<Factory, TaskDTOModule<ErrorRecoveryIndexationTask, ErrorRecoveryIndexationTaskDTO>> MODULE = factory -> (TaskDTOModule)DTOModule.forDomainObject(ErrorRecoveryIndexationTask.class).convertToDTO(ErrorRecoveryIndexationTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(ErrorRecoveryIndexationTaskDTO::of).typeName(PREVIOUS_FAILURES_INDEXING).withFactory(TaskDTOModule::new);
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReprocessingContextInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;
    private final ReIndexingExecutionFailures previousFailures;

    public ErrorRecoveryIndexationTask(ReIndexerPerformer reIndexerPerformer, ReIndexingExecutionFailures previousFailures) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.previousFailures = previousFailures;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new ReprocessingContextInformation(this.reprocessingContext);
    }

    public Task.Result run() {
        return this.reIndexerPerformer.reIndex(this.reprocessingContext, this.previousFailures);
    }

    public String type() {
        return PREVIOUS_FAILURES_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        private List<ReIndexingExecutionFailures.ReIndexingFailure> failuresFromDTO(List<ErrorRecoveryIndexationTaskDTO.ReindexingFailureDTO> failureDTOs) {
            return (List)failureDTOs.stream().flatMap(dto -> dto.getUids().stream().map(uid -> new ReIndexingExecutionFailures.ReIndexingFailure(this.mailboxIdFactory.fromString(dto.getMailboxId()), MessageUid.of((long)uid)))).collect(Guavate.toImmutableList());
        }

        public ErrorRecoveryIndexationTask create(ErrorRecoveryIndexationTaskDTO dto) {
            return new ErrorRecoveryIndexationTask(this.reIndexerPerformer, new ReIndexingExecutionFailures(this.failuresFromDTO(dto.getPreviousFailures())));
        }
    }

    public static class ErrorRecoveryIndexationTaskDTO
    implements TaskDTO {
        private final String type;
        private final List<ReindexingFailureDTO> previousFailures;

        public static ErrorRecoveryIndexationTaskDTO of(ErrorRecoveryIndexationTask task, String type) {
            Multimap failuresByMailboxId = (Multimap)task.previousFailures.failures().stream().collect(Guavate.toImmutableListMultimap(ReIndexingExecutionFailures.ReIndexingFailure::getMailboxId, Function.identity()));
            List failureDTOs = (List)failuresByMailboxId.asMap().entrySet().stream().map(ErrorRecoveryIndexationTaskDTO::failuresByMailboxToReindexingFailureDTO).collect(Guavate.toImmutableList());
            return new ErrorRecoveryIndexationTaskDTO(type, failureDTOs);
        }

        private static ReindexingFailureDTO failuresByMailboxToReindexingFailureDTO(Map.Entry<MailboxId, Collection<ReIndexingExecutionFailures.ReIndexingFailure>> entry) {
            List uids = (List)entry.getValue().stream().map(ReIndexingExecutionFailures.ReIndexingFailure::getUid).map(MessageUid::asLong).collect(Guavate.toImmutableList());
            return new ReindexingFailureDTO(entry.getKey().serialize(), uids);
        }

        private ErrorRecoveryIndexationTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="previousFailures") List<ReindexingFailureDTO> previousFailures) {
            this.type = type;
            this.previousFailures = previousFailures;
        }

        public String getType() {
            return this.type;
        }

        public List<ReindexingFailureDTO> getPreviousFailures() {
            return this.previousFailures;
        }

        public static class ReindexingFailureDTO {
            private final String mailboxId;
            private final List<Long> uids;

            private ReindexingFailureDTO(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uids") List<Long> uids) {
                this.mailboxId = mailboxId;
                this.uids = uids;
            }

            public String getMailboxId() {
                return this.mailboxId;
            }

            public List<Long> getUids() {
                return this.uids;
            }
        }
    }
}

