/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.Hostname;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.ScalaEventSourcingSystem$;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u000f\u001e\u0001!B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"A\u0011\n\u0001B\u0001B\u0003%!\t\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0001L\u0011!y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011A)\t\u0011U\u0003!\u0011!Q\u0001\nIC\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00051\"1A\f\u0001C\u0001;uCqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002?\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u0018!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u00020!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002<!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t\u0019\u0007\u0001C!\u0003gBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\"\u0002!\t%a)\t\u000f\u00055\u0006\u0001\"\u0012\u00020\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r'\u0001G#wK:$8k\\;sG&tw\rV1tW6\u000bg.Y4fe*\u0011adH\u0001\u000eKZ,g\u000e^:pkJ\u001c\u0017N\\4\u000b\u0005\u0001\n\u0013\u0001\u0002;bg.T!AI\u0012\u0002\u000b)\fW.Z:\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011&M\u001b\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1qJ\u00196fGR\u0004\"AM\u001a\u000e\u0003}I!\u0001N\u0010\u0003\u0017Q\u000b7o['b]\u0006<WM\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q5\n!![8\n\u0005i:$!C\"m_N,\u0017M\u00197f\u0003E9xN]6Rk\u0016,XmU;qa2LWM\u001d\t\u0003{yj\u0011!H\u0005\u0003\u007fu\u0011\u0011cV8sWF+X-^3TkB\u0004H.[3s\u0003))g/\u001a8u'R|'/Z\u000b\u0002\u0005B\u00111iR\u0007\u0002\t*\u0011QIR\u0001\u000bKZ,g\u000e^:u_J,'B\u0001\u0010\"\u0013\tAEI\u0001\u0006Fm\u0016tGo\u0015;pe\u0016\f1\"\u001a<f]R\u001cFo\u001c:fA\u0005QR\r_3dkRLwN\u001c#fi\u0006LGn\u001d)s_*,7\r^5p]V\tA\n\u0005\u0002>\u001b&\u0011a*\b\u0002\u001f)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\f1$\u001a=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\u0004\u0013\u0001\u00035pgRt\u0017-\\3\u0016\u0003I\u0003\"!P*\n\u0005Qk\"\u0001\u0003%pgRt\u0017-\\3\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0013!\u0006;fe6Lg.\u0019;j_:\u001cVOY:de&\u0014WM]\u000b\u00021B\u0011Q(W\u0005\u00035v\u0011Q\u0003V3s[&t\u0017\r^5p]N+(m]2sS\n,'/\u0001\fuKJl\u0017N\\1uS>t7+\u001e2tGJL'-\u001a:!\u0003\u0019a\u0014N\\5u}Q1al\u00181bE\u000e\u0004\"!\u0010\u0001\t\u000bmR\u0001\u0019\u0001\u001f\t\u000b\u0001S\u0001\u0019\u0001\"\t\u000b)S\u0001\u0019\u0001'\t\u000bAS\u0001\u0019\u0001*\t\u000bYS\u0001\u0019\u0001-)\u0005))\u0007C\u00014p\u001b\u00059'B\u00015j\u0003-\tgN\\8uCRLwN\\:\u000b\u0005)\\\u0017AB2p[6|gN\u0003\u0002m[\u00061qm\\8hY\u0016T\u0011A\\\u0001\u0004G>l\u0017B\u00019h\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0015\u0003\u0015I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\r%t'.Z2u\u0015\u00059\u0018!\u00026bm\u0006D\u0018BA=u\u0005\u0019IeN[3di\u00069B-\u001a7bs\n+Go^3f]B{G\u000e\\5oO&sWj]\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT\u0011a`\u0001\u0006g\u000e\fG.Y\u0005\u0004\u0003\u0007q(aA%oi\u0006AB-\u001a7bs\n+Go^3f]B{G\u000e\\5oO&sWj\u001d\u0011\u0002\u001d]|'o\u001b#jgB\fGo\u00195feV\u0011\u00111\u0002\t\u0005\u0003\u001b\ty!D\u0001G\u0013\r\t\tB\u0012\u0002\u000b'V\u00147o\u0019:jE\u0016\u0014\u0018a\u00037pC\u0012D\u0015n\u001d;pef,\"!a\u0006\u0011\u000fu\fI\"!\b\u0002$%\u0019\u00111\u0004@\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0007\u0003?I1!!\tG\u0005-\tum\u001a:fO\u0006$X-\u00133\u0011\u0007\r\u000b)#C\u0002\u0002(\u0011\u0013q\u0001S5ti>\u0014\u00180\u0001\u0007m_\u0006$\u0007*[:u_JL\b%A\nfm\u0016tGoU8ve\u000eLgnZ*zgR,W.\u0006\u0002\u00020A!\u0011QBA\u0019\u0013\r\t\u0019D\u0012\u0002\u0014\u000bZ,g\u000e^*pkJ\u001c\u0017N\\4TsN$X-\\\u0001\u0015KZ,g\u000e^*pkJ\u001c\u0017N\\4TsN$X-\u001c\u0011\u0002\u0013]|'o[)vKV,WCAA\u001e!\r\u0011\u0014QH\u0005\u0004\u0003\u007fy\"!C,pe.\fV/Z;f\u0003)9xN]6Rk\u0016,X\rI\u0001\u0007gV\u0014W.\u001b;\u0015\t\u0005\u001d\u0013Q\n\t\u0004e\u0005%\u0013bAA&?\t1A+Y:l\u0013\u0012Da\u0001\t\u000bA\u0002\u0005=\u0003c\u0001\u001a\u0002R%\u0019\u00111K\u0010\u0003\tQ\u000b7o[\u0001\u0014O\u0016$X\t_3dkRLwN\u001c#fi\u0006LGn\u001d\u000b\u0005\u00033\ny\u0006E\u00023\u00037J1!!\u0018 \u0005Q!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mg\"9\u0011\u0011M\u000bA\u0002\u0005\u001d\u0013AA5e\u0003\u0011a\u0017n\u001d;\u0015\u0005\u0005\u001d\u0004CBA5\u0003_\nI&\u0004\u0002\u0002l)\u0019\u0011QN\u0017\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\nYG\u0001\u0003MSN$H\u0003BA4\u0003kBq!a\u001e\u0018\u0001\u0004\tI(\u0001\u0004ti\u0006$Xo\u001d\t\u0005\u0003w\n\tID\u00023\u0003{J1!a  \u0003-!\u0016m]6NC:\fw-\u001a:\n\t\u0005\r\u0015Q\u0011\u0002\u0007'R\fG/^:\u000b\u0007\u0005}t$A\u0005mSN$8kY1mCV\u0011\u00111\u0012\t\u0007\u0003\u001b\u000bi*!\u0017\u000f\t\u0005=\u0015\u0011\u0014\b\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0018bAAN}\u00069\u0001/Y2lC\u001e,\u0017\u0002BA9\u0003?S1!a'\u007f\u0003\u0019\u0019\u0017M\\2fYR!\u0011QUAV!\ri\u0018qU\u0005\u0004\u0003Ss(\u0001B+oSRDq!!\u0019\u001a\u0001\u0004\t9%A\u0003bo\u0006LG\u000f\u0006\u0003\u0002Z\u0005E\u0006bBA15\u0001\u0007\u0011q\t\u0015\u00045\u0005U\u0006\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005mf0\u0001\u0006b]:|G/\u0019;j_:LA!a0\u0002:\n9A/Y5me\u0016\u001c\u0017!B2m_N,GCAAS\u0001")
public class EventSourcingTaskManager
implements TaskManager,
Closeable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final int delayBetweenPollingInMs;
    private final Function1<AggregateId, History> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    private int delayBetweenPollingInMs() {
        return this.delayBetweenPollingInMs;
    }

    private Subscriber workDispatcher() {
        return x0$1 -> {
            Event event = x0$1;
            if (event instanceof Created) {
                Created created = (Created)event;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (event instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
    }

    private Function1<AggregateId, History> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TaskId submit(Task task) {
        void var2_2;
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        this.eventSourcingSystem().dispatch((Command)command);
        return var2_2;
    }

    @Override
    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    @Override
    public java.util.List<TaskExecutionDetails> list() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.listScala()).asJava();
    }

    @Override
    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.listScala().filter((Function1 & Serializable & scala.Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return (List)this.executionDetailsProjection().list().flatMap((Function1 & Serializable & scala.Serializable)details -> Option$.MODULE$.option2Iterable(this.executionDetailsProjection().load(details.taskId())), List$.MODULE$.canBuildFrom());
    }

    @Override
    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        this.eventSourcingSystem().dispatch((Command)command);
    }

    @Override
    public final TaskExecutionDetails await(TaskId id) {
        TaskExecutionDetails details;
        while (!(details = this.getExecutionDetails(id)).getStatus().isFinished()) {
            Thread.sleep(this.delayBetweenPollingInMs());
        }
        return details;
    }

    @Override
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !((Object)((Object)status)).equals((Object)status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.delayBetweenPollingInMs = 500;
        this.loadHistory = (Function1 & Serializable & scala.Serializable)x$1 -> this.eventStore().getEventsOfAggregate(x$1);
        this.eventSourcingSystem = ScalaEventSourcingSystem$.MODULE$.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory())})), (Set<Subscriber>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber}))), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

