/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.util.Arrays;
import java.util.List;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;

public interface TaskManager {
    public static final boolean FINISHED = true;

    public TaskId submit(Task var1);

    public TaskExecutionDetails getExecutionDetails(TaskId var1);

    public List<TaskExecutionDetails> list();

    public List<TaskExecutionDetails> list(Status var1);

    public void cancel(TaskId var1);

    public TaskExecutionDetails await(TaskId var1);

    public static enum Status {
        WAITING("waiting", false),
        IN_PROGRESS("inProgress", false),
        CANCEL_REQUESTED("canceledRequested", false),
        COMPLETED("completed", true),
        CANCELLED("canceled", true),
        FAILED("failed", true);

        private final String value;
        private final boolean finished;

        public static Status fromString(String value) {
            return Arrays.stream(Status.values()).filter(status -> status.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown status value '%s'", value)));
        }

        private Status(String value, boolean finished) {
            this.value = value;
            this.finished = finished;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

