/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.task.TaskExecutionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Task {
    public static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    public static final String TASK_ID = "taskId";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_DETAILS = "taskDetails";
    public static final String UNKNOWN = "unknown";

    public static Result combine(Result result1, Result result2) {
        if (result1 == Result.COMPLETED && result2 == Result.COMPLETED) {
            return Result.COMPLETED;
        }
        return Result.PARTIAL;
    }

    public Result run() throws InterruptedException;

    default public String type() {
        return UNKNOWN;
    }

    default public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.empty();
    }

    public static enum Result {
        COMPLETED,
        PARTIAL;


        public Result onComplete(Operation ... operations) {
            return this.onComplete(Arrays.stream(operations).map(this::wrap));
        }

        public Result onComplete(CompletionOperation ... operation) {
            return this.onComplete(Arrays.stream(operation));
        }

        private Result onComplete(Stream<CompletionOperation> operation) {
            try {
                if (this == COMPLETED) {
                    this.run(operation);
                }
                return this;
            }
            catch (Exception e) {
                LOGGER.error("Error while executing operation", (Throwable)e);
                return PARTIAL;
            }
        }

        public Result onFailure(Operation ... operations) {
            if (this == PARTIAL) {
                this.run(Arrays.stream(operations).map(this::wrap));
            }
            return this;
        }

        private CompletionOperation wrap(Operation o) {
            return result -> o.run();
        }

        private void run(Stream<CompletionOperation> operations) {
            operations.forEach(operation -> operation.complete(this));
        }
    }

    public static interface CompletionOperation {
        public void complete(Result var1);
    }

    public static interface Operation {
        public void run();
    }
}

